/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.azure.keyvault.authentication.KeyVaultCredentials;
import java.net.MalformedURLException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AzureKeyVaultCredential
extends KeyVaultCredentials {
    private static final long DEFAULT_TOKEN_ACQUIRE_TIMEOUT_IN_SECONDS = 60L;
    private String clientId;
    private String clientKey;
    private long timeoutInSeconds;

    public AzureKeyVaultCredential(String clientId, String clientKey, long timeoutInSeconds) {
        this.clientId = clientId;
        this.clientKey = clientKey;
        this.timeoutInSeconds = timeoutInSeconds;
    }

    public AzureKeyVaultCredential(String clientId, String clientKey) {
        this(clientId, clientKey, 60L);
    }

    public String doAuthenticate(String authorization, String resource, String scope) {
        AuthenticationContext context = null;
        AuthenticationResult result = null;
        String token = "";
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            context = new AuthenticationContext(authorization, false, executorService);
            ClientCredential credential = new ClientCredential(this.clientId, this.clientKey);
            Future future = context.acquireToken(resource, credential, null);
            result = (AuthenticationResult)future.get(this.timeoutInSeconds, TimeUnit.SECONDS);
            token = result.getAccessToken();
        }
        catch (InterruptedException | MalformedURLException | ExecutionException | TimeoutException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        finally {
            executorService.shutdown();
        }
        return token;
    }
}

