/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.aad.adal4j.UserAssertion;
import com.microsoft.azure.spring.autoconfigure.aad.AADAuthenticationFilterProperties;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpoints;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpointsProperties;
import com.microsoft.azure.spring.autoconfigure.aad.UserPrincipal;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.naming.ServiceUnavailableException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.filter.OncePerRequestFilter;

public class AADAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AADAuthenticationFilter.class);
    private static final String CURRENT_USER_PRINCIPAL = "CURRENT_USER_PRINCIPAL";
    private static final String CURRENT_USER_PRINCIPAL_GRAPHAPI_TOKEN = "CURRENT_USER_PRINCIPAL_GRAPHAPI_TOKEN";
    private static final String TOKEN_HEADER = "Authorization";
    private static final String TOKEN_TYPE = "Bearer ";
    private AADAuthenticationFilterProperties aadAuthFilterProp;
    private ServiceEndpointsProperties serviceEndpointsProp;

    public AADAuthenticationFilter(AADAuthenticationFilterProperties aadAuthFilterProp, ServiceEndpointsProperties serviceEndpointsProp) {
        this.aadAuthFilterProp = aadAuthFilterProp;
        this.serviceEndpointsProp = serviceEndpointsProp;
    }

    private AuthenticationResult acquireTokenForGraphApi(String idToken, String tenantId, ServiceEndpoints serviceEndpoints) throws Throwable {
        ClientCredential credential = new ClientCredential(this.aadAuthFilterProp.getClientId(), this.aadAuthFilterProp.getClientSecret());
        UserAssertion assertion = new UserAssertion(idToken);
        AuthenticationResult result = null;
        ExecutorService service = null;
        try {
            service = Executors.newFixedThreadPool(1);
            AuthenticationContext context = new AuthenticationContext(serviceEndpoints.getAadSigninUri() + tenantId + "/", true, service);
            Future future = context.acquireToken(serviceEndpoints.getAadGraphApiUri(), assertion, credential, null);
            result = (AuthenticationResult)future.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
        if (result == null) {
            throw new ServiceUnavailableException("unable to acquire on-behalf-of token for client " + this.aadAuthFilterProp.getClientId());
        }
        return result;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String authHeader = request.getHeader(TOKEN_HEADER);
        if (authHeader != null && authHeader.startsWith(TOKEN_TYPE)) {
            try {
                String idToken = authHeader.replace(TOKEN_TYPE, "");
                UserPrincipal principal = (UserPrincipal)request.getSession().getAttribute(CURRENT_USER_PRINCIPAL);
                String graphApiToken = (String)request.getSession().getAttribute(CURRENT_USER_PRINCIPAL_GRAPHAPI_TOKEN);
                ServiceEndpoints serviceEndpoints = this.serviceEndpointsProp.getServiceEndpoints(this.aadAuthFilterProp.getEnvironment());
                if (principal == null || graphApiToken == null || graphApiToken.isEmpty()) {
                    principal = new UserPrincipal(idToken, serviceEndpoints);
                    graphApiToken = this.acquireTokenForGraphApi(idToken, principal.getClaim().toString(), serviceEndpoints).getAccessToken();
                    request.getSession().setAttribute(CURRENT_USER_PRINCIPAL, (Object)principal);
                    request.getSession().setAttribute(CURRENT_USER_PRINCIPAL_GRAPHAPI_TOKEN, (Object)graphApiToken);
                }
                PreAuthenticatedAuthenticationToken authentication = new PreAuthenticatedAuthenticationToken((Object)principal, null, principal.getAuthoritiesByUserGroups(principal.getGroups(graphApiToken), this.aadAuthFilterProp.getActiveDirectoryGroups()));
                authentication.setAuthenticated(true);
                log.info("Request token verification success. {}", (Object)authentication);
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

