/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;

public class AzureADGraphClient {
    public static String getUserMembershipsV1(String accessToken, String aadMembershipRestAPI) throws Exception {
        URL url = new URL(aadMembershipRestAPI);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestProperty("api-version", "1.6");
        conn.setRequestProperty("Authorization", accessToken);
        conn.setRequestProperty("Accept", "application/json;odata=minimalmetadata");
        String responseInJson = AzureADGraphClient.getResponseStringFromConn(conn);
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            return responseInJson;
        }
        throw new Exception(responseInJson);
    }

    private static String getResponseStringFromConn(HttpURLConnection conn) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            StringBuilder stringBuffer = new StringBuilder();
            String line = "";
            while ((line = reader.readLine()) != null) {
                stringBuffer.append(line);
            }
            String string = stringBuffer.toString();
            return string;
        }
    }
}

