/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import java.io.IOException;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;

public class YamlFileApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final String SERVICE_ENDPOINTS_YAML = "classpath:serviceEndpoints.yml";

    public void initialize(ConfigurableApplicationContext applicationContext) {
        try {
            Resource resource = applicationContext.getResource(SERVICE_ENDPOINTS_YAML);
            YamlPropertySourceLoader sourceLoader = new YamlPropertySourceLoader();
            PropertySource serviceEndpoints = sourceLoader.load("serviceEndpoints", resource, null);
            applicationContext.getEnvironment().getPropertySources().addFirst(serviceEndpoints);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load the azure service endpoints configuration", e);
        }
    }
}

