/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloundfoundry.environment;

import com.microsoft.azure.spring.cloundfoundry.environment.VcapPojo;
import com.microsoft.azure.spring.cloundfoundry.environment.VcapServiceType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

public class VcapResult {
    private static final String AZURE_SERVICE_BUS_DOMAIN = "servicebus.windows.net";
    private static final String PROPERTY_SOURCE_NAME = "defaultProperties";
    private static final String RESULT = "result";
    private static final String CONNECTION_STRING = "connectionString";
    private static final String URI = "uri";
    private static final String KEY = "key";
    private static final String DATABASE = "database";
    private ConfigurableEnvironment confEnv;
    private VcapPojo[] pojos = null;
    private boolean logFlag = false;

    @SuppressFBWarnings(value={"UWF_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"})
    public void populateProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.populateDefaultStorageProperties(map, this.findPojoForServiceType(VcapServiceType.AZURE_STORAGE));
        this.populateDefaultServiceBusProperties(map, this.findPojoForServiceType(VcapServiceType.AZURE_SERVICEBUS));
        this.populateDefaultDocumentDBProperties(map, this.findPojoForServiceType(VcapServiceType.AZURE_DOCUMENTDB));
        this.addOrReplace(this.confEnv.getPropertySources(), map);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public VcapPojo[] getPojos() {
        return this.pojos;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public void setPojos(VcapPojo[] pojos) {
        this.pojos = pojos;
    }

    public ConfigurableEnvironment getConfEnv() {
        return this.confEnv;
    }

    public void setConfEnv(ConfigurableEnvironment confEnv) {
        this.confEnv = confEnv;
    }

    public void setLogFlag(boolean logFlag) {
        this.logFlag = logFlag;
    }

    private VcapPojo findPojoForServiceType(VcapServiceType serviceType) {
        VcapPojo pojo = null;
        switch (this.findCountByServiceType(serviceType)) {
            case 0: {
                this.log("VcapResult.findPojoForServiceType: No services of type " + serviceType.toString() + " found.");
                break;
            }
            case 1: {
                this.log("VcapResult.findPojoForServiceType: One services of type " + serviceType.toString() + " found.");
                pojo = this.findByServiceType(serviceType);
                if (pojo == null) break;
                this.log("VcapResult.findPojoForServiceType: Found the matching pojo");
                break;
            }
            default: {
                this.log("VcapResult.findPojoForServiceType: More than one service of type " + serviceType.toString() + " found, cannot autoconfigure service, must use factory instead.");
            }
        }
        return pojo;
    }

    private int findCountByServiceType(VcapServiceType serviceType) {
        int result = 0;
        if (serviceType != null) {
            for (int i = 0; i < this.pojos.length; ++i) {
                VcapPojo pojo = this.pojos[i];
                if (!serviceType.toString().equals(pojo.getServiceBrokerName())) continue;
                ++result;
            }
        }
        return result;
    }

    private void populateDefaultStorageProperties(Map<String, Object> map, VcapPojo pojo) {
        this.log("VcapResult.populateDefaultStorageProperties " + pojo);
        map.put("azure.storage.result", this);
        if (pojo != null) {
            map.put("azure.storage.connectionString", this.buildStorageConnectionString(pojo));
            this.log("VcapResult.populateDefaultStorageProperties: Updated Storage properties");
        }
    }

    private String buildStorageConnectionString(VcapPojo pojo) {
        String storageConnectionString = "DefaultEndpointsProtocol=http;AccountName=" + pojo.getCredentials().get("storage_account_name") + ";AccountKey=" + pojo.getCredentials().get("primary_access_key");
        this.log("storageConnectionString = " + storageConnectionString);
        return storageConnectionString;
    }

    private void populateDefaultServiceBusProperties(Map<String, Object> map, VcapPojo pojo) {
        this.log("VcapResult.populateDefaultServiceBusProperties " + pojo);
        map.put("azure.servicebus.result", this);
        if (pojo != null) {
            map.put("azure.servicebus.connectionString", this.buildServiceBusConnectString(pojo));
            this.log("VcapResult.populateDefaultServiceBusProperties: Updated Service Bus properties");
        }
    }

    private String buildServiceBusConnectString(VcapPojo pojo) {
        String connectionString = "Endpoint=sb://" + pojo.getCredentials().get("namespace_name") + "." + AZURE_SERVICE_BUS_DOMAIN + "/;SharedAccessKeyName=" + pojo.getCredentials().get("shared_access_key_name") + ";SharedAccessKey=" + pojo.getCredentials().get("shared_access_key_value");
        this.log("connectionString name = " + connectionString);
        return connectionString;
    }

    private void populateDefaultDocumentDBProperties(Map<String, Object> map, VcapPojo pojo) {
        this.log("VcapResult.populateDefaultDocumentDBProperties " + pojo);
        map.put("azure.documentdb.result", this);
        if (pojo != null) {
            map.put("azure.documentdb.uri", pojo.getCredentials().get("documentdb_host_endpoint"));
            map.put("azure.documentdb.key", pojo.getCredentials().get("documentdb_master_key"));
            map.put("azure.documentdb.database", pojo.getCredentials().get("documentdb_database_id"));
            this.log("VcapResult.populateDefaultDocumentDBProperties: Updated DocumentDB properties");
        }
    }

    private VcapPojo findByServiceType(VcapServiceType serviceType) {
        VcapPojo result = null;
        if (serviceType != null) {
            for (int i = 0; i < this.pojos.length; ++i) {
                VcapPojo pojo = this.pojos[i];
                if (!serviceType.toString().equals(pojo.getServiceBrokerName())) continue;
                result = pojo;
                break;
            }
        }
        return result;
    }

    @SuppressFBWarnings(value={"WMI_WRONG_MAP_ITERATOR"})
    private void addOrReplace(MutablePropertySources propertySources, Map<String, Object> map) {
        PropertySource source;
        MapPropertySource target = null;
        if (propertySources.contains(PROPERTY_SOURCE_NAME) && (source = propertySources.get(PROPERTY_SOURCE_NAME)) instanceof MapPropertySource) {
            target = (MapPropertySource)source;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (target.containsProperty(entry.getKey())) continue;
                ((Map)target.getSource()).put(entry.getKey(), map.get(entry.getKey()));
            }
        }
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            propertySources.addLast((PropertySource)target);
        }
    }

    private void log(String msg) {
        if (this.logFlag) {
            System.out.println(msg);
        }
    }
}

