/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.cosmosdb;

import com.microsoft.azure.documentdb.ConnectionPolicy;
import com.microsoft.azure.documentdb.DocumentClient;
import com.microsoft.azure.spring.autoconfigure.cosmosdb.DocumentDBProperties;
import com.microsoft.azure.spring.data.cosmosdb.config.AbstractDocumentDbConfiguration;
import com.microsoft.azure.spring.data.cosmosdb.config.DocumentDBConfig;
import com.microsoft.azure.spring.data.cosmosdb.core.DocumentDbTemplate;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={DocumentClient.class, DocumentDbTemplate.class})
@EnableConfigurationProperties(value={DocumentDBProperties.class})
public class DocumentDBAutoConfiguration
extends AbstractDocumentDbConfiguration {
    private final DocumentDBProperties properties;
    private final ConnectionPolicy policy;

    public DocumentDBAutoConfiguration(DocumentDBProperties properties, ObjectProvider<ConnectionPolicy> connectionPolicyObjectProvider) {
        this.properties = properties;
        this.policy = (ConnectionPolicy)connectionPolicyObjectProvider.getIfAvailable();
        this.configConnectionPolicy(properties, this.policy);
    }

    public DocumentDBConfig getConfig() {
        DocumentDBConfig config = DocumentDBConfig.builder((String)this.properties.getUri(), (String)this.properties.getKey(), (String)this.properties.getDatabase()).consistencyLevel(this.properties.getConsistencyLevel()).allowTelemetry(this.properties.isAllowTelemetry()).connectionPolicy(this.properties.getConnectionPolicy()).build();
        return config;
    }

    private void configConnectionPolicy(DocumentDBProperties properties, ConnectionPolicy connectionPolicy) {
        ConnectionPolicy policy = connectionPolicy == null ? ConnectionPolicy.GetDefault() : connectionPolicy;
        properties.setConnectionPolicy(policy);
    }
}

