/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.mediaservices;

import com.microsoft.azure.spring.autoconfigure.mediaservices.MediaServicesProperties;
import com.microsoft.azure.telemetry.TelemetryProxy;
import com.microsoft.windowsazure.Configuration;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.services.media.MediaConfiguration;
import com.microsoft.windowsazure.services.media.MediaContract;
import com.microsoft.windowsazure.services.media.MediaService;
import com.microsoft.windowsazure.services.media.authentication.AzureAdClientSymmetricKey;
import com.microsoft.windowsazure.services.media.authentication.AzureAdTokenCredentials;
import com.microsoft.windowsazure.services.media.authentication.AzureAdTokenProvider;
import com.microsoft.windowsazure.services.media.authentication.AzureEnvironments;
import com.microsoft.windowsazure.services.media.authentication.TokenProvider;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@org.springframework.context.annotation.Configuration
@ConditionalOnMissingBean(value={MediaContract.class})
@EnableConfigurationProperties(value={MediaServicesProperties.class})
@ConditionalOnProperty(prefix="azure.mediaservices", value={"tenant", "client-id", "client-secret", "rest-api-endpoint"})
public class MediaServicesAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(MediaServicesAutoConfiguration.class);
    private final MediaServicesProperties properties;
    private final TelemetryProxy telemetryProxy;

    public MediaServicesAutoConfiguration(MediaServicesProperties mediaServicesProperties) {
        this.properties = mediaServicesProperties;
        this.telemetryProxy = new TelemetryProxy(mediaServicesProperties.isAllowTelemetry());
    }

    @Bean
    public MediaContract mediaContract() throws ServiceException, MalformedURLException, URISyntaxException {
        LOG.debug("mediaContract called");
        this.trackCustomEvent();
        return this.createMediaContract();
    }

    private MediaContract createMediaContract() throws ServiceException, MalformedURLException, URISyntaxException {
        LOG.debug("createMediaContract called");
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        AzureAdTokenCredentials credentials = new AzureAdTokenCredentials(this.properties.getTenant(), new AzureAdClientSymmetricKey(this.properties.getClientId(), this.properties.getClientSecret()), AzureEnvironments.AZURE_CLOUD_ENVIRONMENT);
        AzureAdTokenProvider tokenProvider = new AzureAdTokenProvider(credentials, executorService);
        Configuration configuration = MediaConfiguration.configureWithAzureAdTokenProvider((URI)new URI(this.properties.getRestApiEndpoint()), (TokenProvider)tokenProvider);
        if (this.properties.getConnectTimeout() != null) {
            configuration.getProperties().put("com.microsoft.windowsazure.Configuration.connectTimeout", this.properties.getConnectTimeout());
        }
        if (this.properties.getReadTimeout() != null) {
            configuration.getProperties().put("com.microsoft.windowsazure.Configuration.readTimeout", this.properties.getReadTimeout());
        }
        if (!StringUtils.isEmpty((Object)this.properties.getProxyHost()) && Objects.nonNull(this.properties.getProxyPort())) {
            configuration.getProperties().put("http.proxyHost", this.properties.getProxyHost());
            configuration.getProperties().put("http.proxyPort", this.properties.getProxyPort());
            configuration.getProperties().put("http.proxyScheme", this.properties.getProxyScheme());
        } else {
            if (!StringUtils.isEmpty((Object)this.properties.getProxyHost()) && Objects.isNull(this.properties.getProxyPort())) {
                throw new ServiceException("Please configure azure.mediaservices.proxy-port");
            }
            if (Objects.nonNull(this.properties.getProxyPort()) && StringUtils.isEmpty((Object)this.properties.getProxyHost())) {
                throw new ServiceException("Please configure azure.mediaservices.proxy-host");
            }
        }
        return MediaService.create((Configuration)configuration);
    }

    private void trackCustomEvent() {
        HashMap<String, String> customTelemetryProperties = new HashMap<String, String>();
        String[] packageNames = this.getClass().getPackage().getName().split("\\.");
        if (packageNames.length > 1) {
            customTelemetryProperties.put("serviceName", packageNames[packageNames.length - 1]);
        }
        this.telemetryProxy.trackEvent(ClassUtils.getUserClass(this.getClass()).getSimpleName(), customTelemetryProperties);
    }
}

