/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.sqlserver;

import com.microsoft.azure.spring.autoconfigure.sqlserver.AlwaysEncryptedDataSourceProperties;
import com.microsoft.azure.spring.autoconfigure.sqlserver.KeyVaultProperties;
import com.microsoft.azure.spring.autoconfigure.sqlserver.KeyVaultProviderInitializer;
import com.microsoft.sqlserver.jdbc.SQLServerDriver;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.jdbc.JndiDataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.XADataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;

@Configuration
@ConditionalOnClass(value={DataSource.class, EmbeddedDatabaseType.class})
@EnableConfigurationProperties(value={AlwaysEncryptedDataSourceProperties.class, KeyVaultProperties.class})
@ConditionalOnProperty(name={"spring.datasource.always-encrypted.enabled"})
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class, JndiDataSourceAutoConfiguration.class, XADataSourceAutoConfiguration.class})
public class AlwaysEncryptedAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AlwaysEncryptedAutoConfiguration.class);

    @Bean(name={"dataSourceKeyVaultInitializer"})
    @ConditionalOnClass(value={SQLServerDriver.class})
    public KeyVaultProviderInitializer dataSourceKeyVaultInitializer(KeyVaultProperties properties) {
        return new KeyVaultProviderInitializer(properties);
    }

    @Configuration
    static class AlwaysEncryptedDataSourcePropertiesConfiguration {
        AlwaysEncryptedDataSourcePropertiesConfiguration() {
        }

        @Bean
        @Primary
        @ConditionalOnClass(value={SQLServerDriver.class})
        public DataSourceProperties dataSourceProperties() {
            LOG.info("Setting AlwaysEncrypted url flag");
            return new AlwaysEncryptedDataSourceProperties();
        }
    }
}

