/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.storage;

import com.microsoft.azure.spring.autoconfigure.storage.StorageProperties;
import com.microsoft.azure.storage.blob.ContainerURL;
import com.microsoft.azure.storage.blob.ICredentials;
import com.microsoft.azure.storage.blob.PipelineOptions;
import com.microsoft.azure.storage.blob.ServiceURL;
import com.microsoft.azure.storage.blob.SharedKeyCredentials;
import com.microsoft.azure.storage.blob.StorageURL;
import com.microsoft.azure.storage.blob.TelemetryOptions;
import com.microsoft.azure.telemetry.TelemetryProxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnClass(value={ServiceURL.class})
@EnableConfigurationProperties(value={StorageProperties.class})
@ConditionalOnProperty(prefix="azure.storage", value={"account-name", "account-key"})
public class StorageAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(StorageAutoConfiguration.class);
    private static final String BLOB_URL = "http://%s.blob.core.windows.net";
    private static final String BLOB_HTTPS_URL = "https://%s.blob.core.windows.net";
    private static final String USER_AGENT_PREFIX = "spring-storage/";
    private final StorageProperties properties;
    private final TelemetryProxy telemetryProxy;

    public StorageAutoConfiguration(StorageProperties properties) {
        this.properties = properties;
        this.telemetryProxy = new TelemetryProxy(properties.isAllowTelemetry());
    }

    @Bean
    public ServiceURL createServiceUrl(@Autowired(required=false) PipelineOptions options) throws InvalidKeyException, MalformedURLException {
        LOG.debug("Creating ServiceURL bean...");
        this.trackCustomEvent();
        SharedKeyCredentials credentials = new SharedKeyCredentials(this.properties.getAccountName(), this.properties.getAccountKey());
        URL blobUrl = this.getURL();
        PipelineOptions pipelineOptions = this.buildOptions(options);
        ServiceURL serviceURL = new ServiceURL(blobUrl, StorageURL.createPipeline((ICredentials)credentials, (PipelineOptions)pipelineOptions));
        return serviceURL;
    }

    private URL getURL() throws MalformedURLException {
        if (this.properties.isEnableHttps()) {
            return new URL(String.format(BLOB_HTTPS_URL, this.properties.getAccountName()));
        }
        return new URL(String.format(BLOB_URL, this.properties.getAccountName()));
    }

    private PipelineOptions buildOptions(PipelineOptions fromOptions) {
        PipelineOptions pipelineOptions = fromOptions == null ? new PipelineOptions() : fromOptions;
        pipelineOptions.withTelemetryOptions(new TelemetryOptions(USER_AGENT_PREFIX + pipelineOptions.telemetryOptions().userAgentPrefix()));
        return pipelineOptions;
    }

    @Bean
    @ConditionalOnProperty(prefix="azure.storage", value={"container-name"})
    public ContainerURL createContainerURL(ServiceURL serviceURL) {
        return serviceURL.createContainerURL(this.properties.getContainerName());
    }

    private void trackCustomEvent() {
        HashMap<String, String> customTelemetryProperties = new HashMap<String, String>();
        String[] packageNames = this.getClass().getPackage().getName().split("\\.");
        if (packageNames.length > 1) {
            customTelemetryProperties.put("serviceName", packageNames[packageNames.length - 1]);
        }
        customTelemetryProperties.putIfAbsent("accountName", this.properties.getAccountName());
        this.telemetryProxy.trackEvent(ClassUtils.getUserClass(this.getClass()).getSimpleName(), customTelemetryProperties);
    }
}

