/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.microsoft.aad.adal4j.ClientCredential;
import com.microsoft.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.microsoft.azure.spring.autoconfigure.aad.AzureADGraphClient;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpointsProperties;
import com.microsoft.azure.spring.autoconfigure.aad.UserPrincipal;
import com.microsoft.azure.spring.autoconfigure.aad.UserPrincipalManager;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.util.ResourceRetriever;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import java.util.concurrent.ExecutionException;
import javax.naming.ServiceUnavailableException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.filter.OncePerRequestFilter;

public class AADAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AADAuthenticationFilter.class);
    private static final String CURRENT_USER_PRINCIPAL = "CURRENT_USER_PRINCIPAL";
    private static final String CURRENT_USER_PRINCIPAL_GRAPHAPI_TOKEN = "CURRENT_USER_PRINCIPAL_GRAPHAPI_TOKEN";
    private static final String TOKEN_HEADER = "Authorization";
    private static final String TOKEN_TYPE = "Bearer ";
    private AADAuthenticationProperties aadAuthProps;
    private ServiceEndpointsProperties serviceEndpointsProps;
    private UserPrincipalManager principalManager;

    public AADAuthenticationFilter(AADAuthenticationProperties aadAuthProps, ServiceEndpointsProperties serviceEndpointsProps, ResourceRetriever resourceRetriever) {
        this.aadAuthProps = aadAuthProps;
        this.serviceEndpointsProps = serviceEndpointsProps;
        this.principalManager = new UserPrincipalManager(serviceEndpointsProps, aadAuthProps, resourceRetriever);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String authHeader = request.getHeader(TOKEN_HEADER);
        if (authHeader != null && authHeader.startsWith(TOKEN_TYPE)) {
            try {
                String idToken = authHeader.replace(TOKEN_TYPE, "");
                UserPrincipal principal = (UserPrincipal)request.getSession().getAttribute(CURRENT_USER_PRINCIPAL);
                String graphApiToken = (String)request.getSession().getAttribute(CURRENT_USER_PRINCIPAL_GRAPHAPI_TOKEN);
                ClientCredential credential = new ClientCredential(this.aadAuthProps.getClientId(), this.aadAuthProps.getClientSecret());
                AzureADGraphClient client = new AzureADGraphClient(credential, this.aadAuthProps, this.serviceEndpointsProps);
                if (principal == null || graphApiToken == null || graphApiToken.isEmpty()) {
                    principal = this.principalManager.buildUserPrincipal(idToken);
                    String tenantId = principal.getClaim().toString();
                    graphApiToken = client.acquireTokenForGraphApi(idToken, tenantId).getAccessToken();
                    principal.setUserGroups(client.getGroups(graphApiToken));
                    request.getSession().setAttribute(CURRENT_USER_PRINCIPAL, (Object)principal);
                    request.getSession().setAttribute(CURRENT_USER_PRINCIPAL_GRAPHAPI_TOKEN, (Object)graphApiToken);
                }
                PreAuthenticatedAuthenticationToken authentication = new PreAuthenticatedAuthenticationToken((Object)principal, null, client.convertGroupsToGrantedAuthorities(principal.getUserGroups()));
                authentication.setAuthenticated(true);
                log.info("Request token verification success. {}", (Object)authentication);
                SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            }
            catch (JOSEException | BadJOSEException | MalformedURLException | ParseException ex) {
                log.error("Failed to initialize UserPrincipal.", ex);
                throw new ServletException(ex);
            }
            catch (InterruptedException | ExecutionException | ServiceUnavailableException ex) {
                log.error("Failed to acquire graph api token.", (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

