/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.servicebus;

import com.microsoft.azure.servicebus.QueueClient;
import com.microsoft.azure.servicebus.SubscriptionClient;
import com.microsoft.azure.servicebus.TopicClient;
import com.microsoft.azure.servicebus.primitives.ConnectionStringBuilder;
import com.microsoft.azure.servicebus.primitives.ServiceBusException;
import com.microsoft.azure.spring.autoconfigure.servicebus.ServiceBusProperties;
import com.microsoft.azure.telemetry.TelemetryProxy;
import java.util.HashMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.ClassUtils;

@Lazy
@Configuration
@EnableConfigurationProperties(value={ServiceBusProperties.class})
@ConditionalOnProperty(prefix="azure.servicebus", value={"connection-string"})
public class ServiceBusAutoConfiguration {
    private final ServiceBusProperties properties;
    private final TelemetryProxy telemetryProxy;

    public ServiceBusAutoConfiguration(ServiceBusProperties properties) {
        this.properties = properties;
        this.telemetryProxy = new TelemetryProxy(properties.isAllowTelemetry());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="azure.servicebus", value={"queue-name", "queue-receive-mode"})
    public QueueClient queueClient() throws InterruptedException, ServiceBusException {
        this.trackCustomEvent();
        return new QueueClient(new ConnectionStringBuilder(this.properties.getConnectionString(), this.properties.getQueueName()), this.properties.getQueueReceiveMode());
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="azure.servicebus", value={"topic-name"})
    public TopicClient topicClient() throws InterruptedException, ServiceBusException {
        this.trackCustomEvent();
        return new TopicClient(new ConnectionStringBuilder(this.properties.getConnectionString(), this.properties.getTopicName()));
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="azure.servicebus", value={"topic-name", "subscription-name", "subscription-receive-mode"})
    public SubscriptionClient subscriptionClient() throws ServiceBusException, InterruptedException {
        this.trackCustomEvent();
        return new SubscriptionClient(new ConnectionStringBuilder(this.properties.getConnectionString(), this.properties.getTopicName() + "/subscriptions/" + this.properties.getSubscriptionName()), this.properties.getSubscriptionReceiveMode());
    }

    private void trackCustomEvent() {
        HashMap<String, String> customTelemetryProperties = new HashMap<String, String>();
        String[] packageNames = this.getClass().getPackage().getName().split("\\.");
        if (packageNames.length > 1) {
            customTelemetryProperties.put("serviceName", packageNames[packageNames.length - 1]);
        }
        this.telemetryProxy.trackEvent(ClassUtils.getUserClass(this.getClass()).getSimpleName(), customTelemetryProperties);
    }
}

