/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.sqlserver;

import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;

@ConfigurationProperties(value="spring.datasource.always-encrypted.keyvault")
public class KeyVaultProperties {
    private String clientId;
    private String clientSecret;
    private boolean allowTelemetry = true;

    @PostConstruct
    public void validate() {
        Assert.hasText((String)this.clientId, (String)"spring.datasource.always-encrypted.keyvault.client-id must be provided");
        Assert.hasText((String)this.clientSecret, (String)"spring.datasource.always-encrypted.keyvault.client-secret must be provided");
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public boolean isAllowTelemetry() {
        return this.allowTelemetry;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setAllowTelemetry(boolean allowTelemetry) {
        this.allowTelemetry = allowTelemetry;
    }
}

