/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.sqlserver;

import com.microsoft.azure.spring.autoconfigure.sqlserver.KeyVaultProperties;
import com.microsoft.azure.telemetry.TelemetryProxy;
import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionAzureKeyVaultProvider;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import java.sql.SQLException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.ClassUtils;

public class KeyVaultProviderInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(KeyVaultProviderInitializer.class);
    private KeyVaultProperties properties;
    private final TelemetryProxy telemetryProxy;

    public KeyVaultProviderInitializer(KeyVaultProperties properties) {
        this.properties = properties;
        this.telemetryProxy = new TelemetryProxy(properties.isAllowTelemetry());
        this.init();
    }

    public void init() {
        LOG.info("initializing DataSource AlwaysEncryption Vault provider");
        this.trackCustomEvent();
        try {
            SQLServerColumnEncryptionAzureKeyVaultProvider akvProvider = new SQLServerColumnEncryptionAzureKeyVaultProvider(this.properties.getClientId(), this.properties.getClientSecret());
            HashMap<String, SQLServerColumnEncryptionAzureKeyVaultProvider> keyStoreMap = new HashMap<String, SQLServerColumnEncryptionAzureKeyVaultProvider>();
            keyStoreMap.put(akvProvider.getName(), akvProvider);
            SQLServerConnection.registerColumnEncryptionKeyStoreProviders(keyStoreMap);
        }
        catch (SQLException ex) {
            LOG.error(ex.getMessage());
            throw new FatalBeanException(ex.getMessage());
        }
    }

    private void trackCustomEvent() {
        HashMap<String, String> customTelemetryProperties = new HashMap<String, String>();
        String[] packageNames = this.getClass().getPackage().getName().split("\\.");
        if (packageNames.length > 1) {
            customTelemetryProperties.put("serviceName", packageNames[packageNames.length - 1]);
        }
        this.telemetryProxy.trackEvent(ClassUtils.getUserClass(this.getClass()).getSimpleName(), customTelemetryProperties);
    }
}

