/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AppServiceMSICredentials;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.spring.AzureKeyVaultCredential;
import com.microsoft.azure.keyvault.spring.AzureKeyVaultMSICredential;
import com.microsoft.azure.keyvault.spring.Constants;
import com.microsoft.azure.keyvault.spring.KeyVaultCertificateCredential;
import com.microsoft.azure.keyvault.spring.KeyVaultOperation;
import com.microsoft.azure.keyvault.spring.KeyVaultPropertySource;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.azure.spring.support.UserAgent;
import com.microsoft.azure.telemetry.TelemetryData;
import com.microsoft.azure.telemetry.TelemetrySender;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

class KeyVaultEnvironmentPostProcessorHelper {
    private static final Logger LOG = LoggerFactory.getLogger(KeyVaultEnvironmentPostProcessorHelper.class);
    private final ConfigurableEnvironment environment;

    public KeyVaultEnvironmentPostProcessorHelper(ConfigurableEnvironment environment) {
        this.environment = environment;
        this.sendTelemetry();
    }

    public void addKeyVaultPropertySource() {
        String vaultUri = this.getProperty(this.environment, "azure.keyvault.uri");
        Long refreshInterval = Optional.ofNullable(this.environment.getProperty("azure.keyvault.refresh-interval")).map(Long::valueOf).orElse(1800000L);
        ServiceClientCredentials credentials = this.getCredentials();
        RestClient restClient = new RestClient.Builder().withBaseUrl(vaultUri).withCredentials(credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withUserAgent(UserAgent.getUserAgent(Constants.AZURE_KEYVAULT_USER_AGENT, this.allowTelemetry(this.environment))).build();
        KeyVaultClient kvClient = new KeyVaultClient(restClient);
        try {
            MutablePropertySources sources = this.environment.getPropertySources();
            KeyVaultOperation kvOperation = new KeyVaultOperation(kvClient, vaultUri, refreshInterval);
            if (sources.contains("systemEnvironment")) {
                sources.addAfter("systemEnvironment", (PropertySource)new KeyVaultPropertySource(kvOperation));
            } else {
                sources.addFirst((PropertySource)new KeyVaultPropertySource(kvOperation));
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to configure KeyVault property source", ex);
        }
    }

    ServiceClientCredentials getCredentials() {
        if (this.environment.containsProperty("MSI_ENDPOINT") && this.environment.containsProperty("MSI_SECRET")) {
            LOG.debug("Will use MSI credentials for app services");
            String msiEndpoint = this.getProperty(this.environment, "MSI_ENDPOINT");
            String msiSecret = this.getProperty(this.environment, "MSI_SECRET");
            return new AppServiceMSICredentials(AzureEnvironment.AZURE, msiEndpoint, msiSecret);
        }
        long timeAcquiringTimeoutInSeconds = (Long)this.environment.getProperty("azure.keyvault.token-acquire-timeout-seconds", Long.class, (Object)60L);
        if (this.environment.containsProperty("azure.keyvault.client-id") && this.environment.containsProperty("azure.keyvault.client-key")) {
            LOG.debug("Will use custom credentials");
            String clientId = this.getProperty(this.environment, "azure.keyvault.client-id");
            String clientKey = this.getProperty(this.environment, "azure.keyvault.client-key");
            return new AzureKeyVaultCredential(clientId, clientKey, timeAcquiringTimeoutInSeconds);
        }
        if (this.environment.containsProperty("azure.keyvault.client-id") && this.environment.containsProperty("azure.keyvault.certificate.path")) {
            String clientId = this.getProperty(this.environment, "azure.keyvault.client-id");
            String certPwd = this.environment.getProperty("azure.keyvault.certificate.password");
            String certPath = this.getProperty(this.environment, "azure.keyvault.certificate.path");
            LOG.info("Read certificate from {}...", (Object)certPath);
            Resource certResource = new DefaultResourceLoader().getResource(certPath);
            return new KeyVaultCertificateCredential(clientId, certResource, certPwd, timeAcquiringTimeoutInSeconds);
        }
        if (this.environment.containsProperty("azure.keyvault.client-id")) {
            LOG.debug("Will use MSI credentials for VMs with specified clientId");
            String clientId = this.getProperty(this.environment, "azure.keyvault.client-id");
            return new AzureKeyVaultMSICredential(AzureEnvironment.AZURE, clientId);
        }
        LOG.debug("Will use MSI credentials for VM");
        return new AzureKeyVaultMSICredential(AzureEnvironment.AZURE);
    }

    private String getProperty(ConfigurableEnvironment env, String propertyName) {
        Assert.notNull((Object)env, (String)"env must not be null!");
        Assert.notNull((Object)propertyName, (String)"propertyName must not be null!");
        String property = env.getProperty(propertyName);
        if (property == null || property.isEmpty()) {
            throw new IllegalArgumentException("property " + propertyName + " must not be null");
        }
        return property;
    }

    private boolean allowTelemetry(ConfigurableEnvironment env) {
        Assert.notNull((Object)env, (String)"env must not be null!");
        return (Boolean)env.getProperty("azure.keyvault.allow.telemetry", Boolean.class, (Object)true);
    }

    private void sendTelemetry() {
        if (this.allowTelemetry(this.environment)) {
            HashMap<String, String> events = new HashMap<String, String>();
            TelemetrySender sender = new TelemetrySender();
            events.put("serviceName", TelemetryData.getClassPackageSimpleName(KeyVaultEnvironmentPostProcessorHelper.class));
            sender.send(ClassUtils.getUserClass(this.getClass()).getSimpleName(), events);
        }
    }
}

