/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.keyvault.KeyVaultClient;
import com.microsoft.azure.keyvault.models.SecretBundle;
import java.util.Collections;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KeyVaultOperation {
    private final long cacheRefreshIntervalInMs;
    private final Object refreshLock = new Object();
    private final KeyVaultClient keyVaultClient;
    private final String vaultUri;
    private ConcurrentHashMap<String, Object> propertyNamesHashMap = new ConcurrentHashMap();
    private final AtomicLong lastUpdateTime = new AtomicLong();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public KeyVaultOperation(KeyVaultClient keyVaultClient, String vaultUri) {
        this(keyVaultClient, vaultUri, 1800000L);
    }

    public KeyVaultOperation(KeyVaultClient keyVaultClient, String vaultUri, long refreshInterval) {
        this.cacheRefreshIntervalInMs = refreshInterval;
        this.keyVaultClient = keyVaultClient;
        this.vaultUri = StringUtils.trimTrailingCharacter((String)vaultUri.trim(), (char)'/');
        this.fillSecretsHashMap();
    }

    public String[] list() {
        try {
            this.rwLock.readLock().lock();
            String[] stringArray = Collections.list(this.propertyNamesHashMap.keys()).toArray(new String[this.propertyNamesHashMap.size()]);
            return stringArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private String getKeyvaultSecretName(@NonNull String property) {
        if (property.matches("[a-z0-9A-Z-]+")) {
            return property.toLowerCase(Locale.US);
        }
        if (property.matches("[A-Z0-9_]+")) {
            return property.toLowerCase(Locale.US).replaceAll("_", "-");
        }
        return property.toLowerCase(Locale.US).replaceAll("-", "").replaceAll("_", "").replaceAll("\\.", "-");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String property) {
        Assert.hasText((String)property, (String)"property should contain text.");
        String secretName = this.getKeyvaultSecretName(property);
        if (System.currentTimeMillis() - this.lastUpdateTime.get() > this.cacheRefreshIntervalInMs) {
            Object object = this.refreshLock;
            synchronized (object) {
                if (System.currentTimeMillis() - this.lastUpdateTime.get() > this.cacheRefreshIntervalInMs) {
                    this.lastUpdateTime.set(System.currentTimeMillis());
                    this.fillSecretsHashMap();
                }
            }
        }
        if (this.propertyNamesHashMap.containsKey(secretName)) {
            SecretBundle secretBundle = this.keyVaultClient.getSecret(this.vaultUri, secretName);
            return secretBundle.value();
        }
        return null;
    }

    private void fillSecretsHashMap() {
        try {
            this.rwLock.writeLock().lock();
            this.propertyNamesHashMap.clear();
            PagedList secrets = this.keyVaultClient.listSecrets(this.vaultUri);
            secrets.loadAll();
            secrets.forEach(s -> {
                String secretName = s.id().replace(this.vaultUri + "/secrets/", "").toLowerCase(Locale.US);
                this.propertyNamesHashMap.putIfAbsent(secretName, s.id());
            });
            this.lastUpdateTime.set(System.currentTimeMillis());
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }
}

