/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.utils;

import com.microsoft.aad.adal4j.AuthenticationContext;
import com.microsoft.aad.adal4j.AuthenticationResult;
import com.microsoft.aad.adal4j.ClientCredential;
import java.net.MalformedURLException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AADAuthUtil {
    public AuthenticationResult getToken(String authorization, String resource, String clientId, String clientKey, long tokenAcquireTimeout) {
        AuthenticationContext context = null;
        AuthenticationResult result = null;
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            context = new AuthenticationContext(authorization, false, executorService);
            ClientCredential credential = new ClientCredential(clientId, clientKey);
            Future future = context.acquireToken(resource, credential, null);
            result = (AuthenticationResult)future.get(tokenAcquireTimeout, TimeUnit.SECONDS);
        }
        catch (InterruptedException | MalformedURLException | ExecutionException | TimeoutException ex) {
            throw new IllegalStateException("Failed to do authentication.", ex);
        }
        finally {
            executorService.shutdown();
        }
        return result;
    }
}

