/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.azure.core.http.rest.PagedIterable;
import com.azure.security.keyvault.secrets.SecretClient;
import com.azure.security.keyvault.secrets.models.KeyVaultSecret;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class KeyVaultOperation {
    private static final Logger log = LoggerFactory.getLogger(KeyVaultOperation.class);
    private final long cacheRefreshIntervalInMs;
    private final List<String> secretKeys;
    private final Object refreshLock = new Object();
    private final SecretClient keyVaultClient;
    private final String vaultUri;
    private ArrayList<String> propertyNames = new ArrayList();
    private String[] propertyNamesArr;
    private final AtomicLong lastUpdateTime = new AtomicLong();
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();

    public KeyVaultOperation(SecretClient keyVaultClient, String vaultUri, long refreshInterval, List<String> secretKeys) {
        this.cacheRefreshIntervalInMs = refreshInterval;
        this.secretKeys = secretKeys;
        this.keyVaultClient = keyVaultClient;
        this.vaultUri = StringUtils.trimTrailingCharacter((String)vaultUri.trim(), (char)'/');
        this.fillSecretsList();
    }

    public String[] list() {
        try {
            this.rwLock.readLock().lock();
            String[] stringArray = this.propertyNamesArr;
            return stringArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private String getKeyvaultSecretName(@NonNull String property) {
        if (property.matches("[a-z0-9A-Z-]+")) {
            return property.toLowerCase(Locale.US);
        }
        if (property.matches("[A-Z0-9_]+")) {
            return property.toLowerCase(Locale.US).replaceAll("_", "-");
        }
        return property.toLowerCase(Locale.US).replaceAll("-", "").replaceAll("_", "").replaceAll("\\.", "-");
    }

    public String get(String property) {
        Assert.hasText((String)property, (String)"property should contain text.");
        String secretName = this.getKeyvaultSecretName(property);
        if (this.secretKeys == null || this.secretKeys.size() == 0) {
            this.refreshPropertyNames();
        }
        if (this.propertyNames.contains(secretName)) {
            KeyVaultSecret secret = this.keyVaultClient.getSecret(secretName);
            return secret == null ? null : secret.getValue();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPropertyNames() {
        if (System.currentTimeMillis() - this.lastUpdateTime.get() > this.cacheRefreshIntervalInMs) {
            Object object = this.refreshLock;
            synchronized (object) {
                if (System.currentTimeMillis() - this.lastUpdateTime.get() > this.cacheRefreshIntervalInMs) {
                    this.lastUpdateTime.set(System.currentTimeMillis());
                    this.fillSecretsList();
                }
            }
        }
    }

    private void fillSecretsList() {
        try {
            this.rwLock.writeLock().lock();
            if (this.secretKeys == null || this.secretKeys.size() == 0) {
                this.propertyNames.clear();
                PagedIterable secretProperties = this.keyVaultClient.listPropertiesOfSecrets();
                secretProperties.forEach(s -> {
                    String secretName = s.getName().replace(this.vaultUri + "/secrets/", "");
                    this.addSecretIfNotExist(secretName);
                });
                this.lastUpdateTime.set(System.currentTimeMillis());
            } else {
                for (String secretKey : this.secretKeys) {
                    this.addSecretIfNotExist(secretKey);
                }
            }
            this.propertyNamesArr = this.propertyNames.toArray(new String[0]);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private void addSecretIfNotExist(String secretName) {
        String secretNameSeparatedByDot;
        String secretNameLowerCase = secretName.toLowerCase(Locale.US);
        if (!this.propertyNames.contains(secretNameLowerCase)) {
            this.propertyNames.add(secretNameLowerCase);
        }
        if (!this.propertyNames.contains(secretNameSeparatedByDot = secretNameLowerCase.replaceAll("-", "."))) {
            this.propertyNames.add(secretNameSeparatedByDot);
        }
    }
}

