/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.microsoft.azure.spring.autoconfigure.aad.UserGroup;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UserPrincipal
implements Serializable {
    private static final long serialVersionUID = -3725690847771476854L;
    private JWSObject jwsObject;
    private JWTClaimsSet jwtClaimsSet;
    private List<UserGroup> userGroups = new ArrayList<UserGroup>();

    public UserPrincipal(JWSObject jwsObject, JWTClaimsSet jwtClaimsSet) {
        this.jwsObject = jwsObject;
        this.jwtClaimsSet = jwtClaimsSet;
    }

    public String getIssuer() {
        return this.jwtClaimsSet == null ? null : this.jwtClaimsSet.getIssuer();
    }

    public String getSubject() {
        return this.jwtClaimsSet == null ? null : this.jwtClaimsSet.getSubject();
    }

    public Map<String, Object> getClaims() {
        return this.jwtClaimsSet == null ? null : this.jwtClaimsSet.getClaims();
    }

    public Object getClaim() {
        return this.jwtClaimsSet == null ? null : this.jwtClaimsSet.getClaim("tid");
    }

    public Object getClaim(String name) {
        return this.jwtClaimsSet == null ? null : this.jwtClaimsSet.getClaim(name);
    }

    public String getUpn() {
        return this.jwtClaimsSet == null ? null : (String)this.jwtClaimsSet.getClaim("upn");
    }

    public String getUniqueName() {
        return this.jwtClaimsSet == null ? null : (String)this.jwtClaimsSet.getClaim("unique_name");
    }

    public String getName() {
        return this.jwtClaimsSet == null ? null : (String)this.jwtClaimsSet.getClaim("name");
    }

    public String getKid() {
        return this.jwsObject == null ? null : this.jwsObject.getHeader().getKeyID();
    }

    public void setUserGroups(List<UserGroup> groups) {
        this.userGroups = groups;
    }

    public List<UserGroup> getUserGroups() {
        return this.userGroups;
    }

    public boolean isMemberOf(UserGroup group) {
        return this.userGroups != null && !this.userGroups.isEmpty() && this.userGroups.contains(group);
    }
}

