/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.b2c;

import com.microsoft.azure.spring.autoconfigure.b2c.AADB2CConfigurationException;
import java.net.MalformedURLException;
import javax.validation.constraints.NotBlank;
import lombok.NonNull;
import org.hibernate.validator.constraints.URL;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="azure.activedirectory.b2c")
public class AADB2CProperties {
    private static final String USER_FLOWS = "user-flows";
    public static final String USER_FLOW_PASSWORD_RESET = "user-flows.password-reset";
    public static final String USER_FLOW_PROFILE_EDIT = "user-flows.profile-edit";
    public static final String USER_FLOW_SIGN_UP_OR_SIGN_IN = "user-flows.sign-up-or-sign-in";
    public static final String DEFAULT_LOGOUT_SUCCESS_URL = "http://localhost:8080/login";
    public static final String PREFIX = "azure.activedirectory.b2c";
    @NotBlank(message="tenant name should not be blank")
    private @NotBlank(message="tenant name should not be blank") String tenant;
    private Boolean oidcEnabled = true;
    @NotBlank(message="client ID should not be blank")
    private @NotBlank(message="client ID should not be blank") String clientId;
    @NotBlank(message="client secret should not be blank")
    private @NotBlank(message="client secret should not be blank") String clientSecret;
    @URL(message="reply URL should be valid URL")
    private @URL(message="reply URL should be valid URL") String replyUrl;
    @URL(message="logout success should be valid URL")
    private @URL(message="logout success should be valid URL") String logoutSuccessUrl = "http://localhost:8080/login";
    private UserFlows userFlows = new UserFlows();
    private boolean allowTelemetry = true;

    private String getReplyURLPath(@URL String replyURL) {
        try {
            return new java.net.URL(replyURL).getPath();
        }
        catch (MalformedURLException e) {
            throw new AADB2CConfigurationException("Failed to get path of given URL.", e);
        }
    }

    @NonNull
    public String getLoginProcessingUrl() {
        return this.getReplyURLPath(this.replyUrl);
    }

    public String getTenant() {
        return this.tenant;
    }

    public Boolean getOidcEnabled() {
        return this.oidcEnabled;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getReplyUrl() {
        return this.replyUrl;
    }

    public String getLogoutSuccessUrl() {
        return this.logoutSuccessUrl;
    }

    public UserFlows getUserFlows() {
        return this.userFlows;
    }

    public boolean isAllowTelemetry() {
        return this.allowTelemetry;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setOidcEnabled(Boolean oidcEnabled) {
        this.oidcEnabled = oidcEnabled;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setReplyUrl(String replyUrl) {
        this.replyUrl = replyUrl;
    }

    public void setLogoutSuccessUrl(String logoutSuccessUrl) {
        this.logoutSuccessUrl = logoutSuccessUrl;
    }

    public void setUserFlows(UserFlows userFlows) {
        this.userFlows = userFlows;
    }

    public void setAllowTelemetry(boolean allowTelemetry) {
        this.allowTelemetry = allowTelemetry;
    }

    @Validated
    protected static class UserFlows {
        @NotBlank(message="sign-up-or-in value should not be blank")
        private @NotBlank(message="sign-up-or-in value should not be blank") String signUpOrSignIn;
        private String profileEdit;
        private String passwordReset;

        public String getSignUpOrSignIn() {
            return this.signUpOrSignIn;
        }

        public String getProfileEdit() {
            return this.profileEdit;
        }

        public String getPasswordReset() {
            return this.passwordReset;
        }

        public void setSignUpOrSignIn(String signUpOrSignIn) {
            this.signUpOrSignIn = signUpOrSignIn;
        }

        public void setProfileEdit(String profileEdit) {
            this.profileEdit = profileEdit;
        }

        public void setPasswordReset(String passwordReset) {
            this.passwordReset = passwordReset;
        }

        protected UserFlows() {
        }
    }
}

