/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.spring;

import com.microsoft.azure.keyvault.spring.KeyVaultPropertySource;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.stereotype.Component;

@ConditionalOnEnabledHealthIndicator(value="azure-key-vault")
@Component
public class KeyVaultHealthIndicator
implements HealthIndicator {
    private final ConfigurableEnvironment environment;

    public KeyVaultHealthIndicator(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public Health health() {
        boolean isUp = this.environment.getPropertySources().stream().filter(propertySource -> propertySource instanceof KeyVaultPropertySource).anyMatch(propertySource -> ((KeyVaultPropertySource)((Object)propertySource)).isUp());
        if (isUp) {
            return Health.up().build();
        }
        return Health.down().build();
    }
}

