/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.microsoft.azure.spring.autoconfigure.aad.UserPrincipal;
import com.microsoft.azure.spring.autoconfigure.aad.UserPrincipalManager;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jwt.proc.BadJWTException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.minidev.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class AADAppRoleStatelessAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AADAppRoleStatelessAuthenticationFilter.class);
    private static final String TOKEN_TYPE = "Bearer ";
    private static final JSONArray DEFAULT_ROLE_CLAIM = new JSONArray().appendElement((Object)"USER");
    private static final String ROLE_PREFIX = "ROLE_";
    private final UserPrincipalManager principalManager;

    public AADAppRoleStatelessAuthenticationFilter(UserPrincipalManager principalManager) {
        this.principalManager = principalManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String authHeader = request.getHeader("Authorization");
        boolean cleanupRequired = false;
        if (!this.alreadyAuthenticated() && StringUtils.hasText((String)authHeader) && authHeader.startsWith(TOKEN_TYPE)) {
            cleanupRequired = this.verifyToken(authHeader.replace(TOKEN_TYPE, ""));
        }
        try {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            if (cleanupRequired) {
                SecurityContextHolder.clearContext();
            }
        }
    }

    private boolean verifyToken(String token) throws ServletException {
        if (!this.principalManager.isTokenIssuedByAAD(token)) {
            LOGGER.info("Token {} is not issued by AAD", (Object)token);
            return false;
        }
        try {
            UserPrincipal principal = this.principalManager.buildUserPrincipal(token);
            JSONArray roles = Optional.ofNullable((JSONArray)principal.getClaims().get("roles")).filter(r -> !r.isEmpty()).orElse(DEFAULT_ROLE_CLAIM);
            PreAuthenticatedAuthenticationToken authentication = new PreAuthenticatedAuthenticationToken((Object)principal, null, this.rolesToGrantedAuthorities(roles));
            authentication.setAuthenticated(true);
            LOGGER.info("Request token verification success. {}", (Object)authentication);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
            return true;
        }
        catch (BadJWTException ex) {
            String errorMessage = "Invalid JWT. Either expired or not yet valid. " + ex.getMessage();
            LOGGER.warn(errorMessage);
            throw new ServletException(errorMessage, (Throwable)ex);
        }
        catch (JOSEException | BadJOSEException | ParseException ex) {
            LOGGER.error("Failed to initialize UserPrincipal.", ex);
            throw new ServletException(ex);
        }
    }

    private boolean alreadyAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && authentication.isAuthenticated();
    }

    protected Set<SimpleGrantedAuthority> rolesToGrantedAuthorities(JSONArray roles) {
        return roles.stream().filter(Objects::nonNull).map(s -> new SimpleGrantedAuthority(ROLE_PREFIX + s)).collect(Collectors.toSet());
    }
}

