/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.microsoft.aad.msal4j.MsalServiceException;
import com.microsoft.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.microsoft.azure.spring.autoconfigure.aad.AzureADGraphClient;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpointsProperties;
import com.microsoft.azure.spring.autoconfigure.aad.UserPrincipal;
import com.microsoft.azure.spring.autoconfigure.aad.UserPrincipalManager;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.source.JWKSetCache;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.util.ResourceRetriever;
import java.io.IOException;
import java.net.MalformedURLException;
import java.text.ParseException;
import javax.naming.ServiceUnavailableException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.filter.OncePerRequestFilter;

public class AADAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AADAuthenticationFilter.class);
    private static final String CURRENT_USER_PRINCIPAL = "CURRENT_USER_PRINCIPAL";
    private static final String CURRENT_USER_PRINCIPAL_GRAPHAPI_TOKEN = "CURRENT_USER_PRINCIPAL_GRAPHAPI_TOKEN";
    private static final String CURRENT_USER_PRINCIPAL_JWT_TOKEN = "CURRENT_USER_PRINCIPAL_JWT_TOKEN";
    private static final String TOKEN_HEADER = "Authorization";
    private static final String TOKEN_TYPE = "Bearer ";
    private AADAuthenticationProperties aadAuthProps;
    private ServiceEndpointsProperties serviceEndpointsProps;
    private UserPrincipalManager principalManager;

    public AADAuthenticationFilter(AADAuthenticationProperties aadAuthProps, ServiceEndpointsProperties serviceEndpointsProps, ResourceRetriever resourceRetriever) {
        this(aadAuthProps, serviceEndpointsProps, new UserPrincipalManager(serviceEndpointsProps, aadAuthProps, resourceRetriever, false));
    }

    public AADAuthenticationFilter(AADAuthenticationProperties aadAuthProps, ServiceEndpointsProperties serviceEndpointsProps, ResourceRetriever resourceRetriever, JWKSetCache jwkSetCache) {
        this(aadAuthProps, serviceEndpointsProps, new UserPrincipalManager(serviceEndpointsProps, aadAuthProps, resourceRetriever, false, jwkSetCache));
    }

    public AADAuthenticationFilter(AADAuthenticationProperties aadAuthProps, ServiceEndpointsProperties serviceEndpointsProps, UserPrincipalManager userPrincipalManager) {
        this.aadAuthProps = aadAuthProps;
        this.serviceEndpointsProps = serviceEndpointsProps;
        this.principalManager = userPrincipalManager;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String authHeader = request.getHeader(TOKEN_HEADER);
        if (!this.alreadyAuthenticated() && authHeader != null && authHeader.startsWith(TOKEN_TYPE)) {
            this.verifyToken(request.getSession(), authHeader.replace(TOKEN_TYPE, ""));
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean alreadyAuthenticated() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && authentication.isAuthenticated();
    }

    private void verifyToken(HttpSession session, String token) throws IOException, ServletException {
        if (!this.principalManager.isTokenIssuedByAAD(token)) {
            LOGGER.info("Token {} is not issued by AAD", (Object)token);
            return;
        }
        try {
            String currentToken = (String)session.getAttribute(CURRENT_USER_PRINCIPAL_JWT_TOKEN);
            UserPrincipal principal = (UserPrincipal)session.getAttribute(CURRENT_USER_PRINCIPAL);
            String graphApiToken = (String)session.getAttribute(CURRENT_USER_PRINCIPAL_GRAPHAPI_TOKEN);
            AzureADGraphClient client = new AzureADGraphClient(this.aadAuthProps.getClientId(), this.aadAuthProps.getClientSecret(), this.aadAuthProps, this.serviceEndpointsProps);
            if (principal == null || graphApiToken == null || graphApiToken.isEmpty() || !token.equals(currentToken)) {
                principal = this.principalManager.buildUserPrincipal(token);
                String tenantId = principal.getClaim().toString();
                graphApiToken = client.acquireTokenForGraphApi(token, tenantId).accessToken();
                principal.setUserGroups(client.getGroups(graphApiToken));
                session.setAttribute(CURRENT_USER_PRINCIPAL, (Object)principal);
                session.setAttribute(CURRENT_USER_PRINCIPAL_GRAPHAPI_TOKEN, (Object)graphApiToken);
                session.setAttribute(CURRENT_USER_PRINCIPAL_JWT_TOKEN, (Object)token);
            }
            PreAuthenticatedAuthenticationToken authentication = new PreAuthenticatedAuthenticationToken((Object)principal, null, client.convertGroupsToGrantedAuthorities(principal.getUserGroups()));
            authentication.setAuthenticated(true);
            LOGGER.info("Request token verification success. {}", (Object)authentication);
            SecurityContextHolder.getContext().setAuthentication((Authentication)authentication);
        }
        catch (JOSEException | BadJOSEException | MalformedURLException | ParseException ex) {
            LOGGER.error("Failed to initialize UserPrincipal.", ex);
            throw new ServletException(ex);
        }
        catch (ServiceUnavailableException ex) {
            LOGGER.error("Failed to acquire graph api token.", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        catch (MsalServiceException ex) {
            if (ex.claims() != null && !ex.claims().isEmpty()) {
                throw new ServletException("Handle conditional access policy", (Throwable)ex);
            }
            throw ex;
        }
    }
}

