/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(value="azure.activedirectory")
public class AADAuthenticationProperties {
    private static final Logger LOGGER = LoggerFactory.getLogger(AADAuthenticationProperties.class);
    private static final String DEFAULT_SERVICE_ENVIRONMENT = "global";
    private static final long DEFAULT_JWKSETCACHE_LIFESPAN = TimeUnit.MINUTES.toMillis(5L);
    private UserGroupProperties userGroup = new UserGroupProperties();
    private String environment = "global";
    private String clientId;
    private String clientSecret;
    private String appIdUri;
    private int jwtConnectTimeout = 500;
    private int jwtReadTimeout = 500;
    private int jwtSizeLimit = 51200;
    private long jwkSetCacheLifespan = DEFAULT_JWKSETCACHE_LIFESPAN;
    private String tenantId;
    private boolean allowTelemetry = true;
    private Boolean sessionStateless = false;

    @DeprecatedConfigurationProperty(reason="Configuration moved to UserGroup class to keep UserGroup properties together", replacement="azure.activedirectory.user-group.allowed-groups")
    public List<String> getActiveDirectoryGroups() {
        return this.userGroup.getAllowedGroups();
    }

    @PostConstruct
    public void validateUserGroupProperties() {
        if (this.sessionStateless.booleanValue()) {
            if (!this.getUserGroup().getAllowedGroups().isEmpty()) {
                LOGGER.warn("Group names are not supported if you set 'sessionSateless' to 'true'.");
            }
        } else if (this.getUserGroup().getAllowedGroups().isEmpty()) {
            throw new IllegalStateException("One of the User Group Properties must be populated. Please populate azure.activedirectory.user-group.allowed-groups");
        }
    }

    public UserGroupProperties getUserGroup() {
        return this.userGroup;
    }

    public void setUserGroup(UserGroupProperties userGroup) {
        this.userGroup = userGroup;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Deprecated
    public void setActiveDirectoryGroups(List<String> activeDirectoryGroups) {
        this.userGroup.setAllowedGroups(activeDirectoryGroups);
    }

    public String getAppIdUri() {
        return this.appIdUri;
    }

    public void setAppIdUri(String appIdUri) {
        this.appIdUri = appIdUri;
    }

    public int getJwtConnectTimeout() {
        return this.jwtConnectTimeout;
    }

    public void setJwtConnectTimeout(int jwtConnectTimeout) {
        this.jwtConnectTimeout = jwtConnectTimeout;
    }

    public int getJwtReadTimeout() {
        return this.jwtReadTimeout;
    }

    public void setJwtReadTimeout(int jwtReadTimeout) {
        this.jwtReadTimeout = jwtReadTimeout;
    }

    public int getJwtSizeLimit() {
        return this.jwtSizeLimit;
    }

    public void setJwtSizeLimit(int jwtSizeLimit) {
        this.jwtSizeLimit = jwtSizeLimit;
    }

    public long getJwkSetCacheLifespan() {
        return this.jwkSetCacheLifespan;
    }

    public void setJwkSetCacheLifespan(long jwkSetCacheLifespan) {
        this.jwkSetCacheLifespan = jwkSetCacheLifespan;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public boolean isAllowTelemetry() {
        return this.allowTelemetry;
    }

    public void setAllowTelemetry(boolean allowTelemetry) {
        this.allowTelemetry = allowTelemetry;
    }

    public Boolean getSessionStateless() {
        return this.sessionStateless;
    }

    public void setSessionStateless(Boolean sessionStateless) {
        this.sessionStateless = sessionStateless;
    }

    public static class UserGroupProperties {
        private List<String> allowedGroups = new ArrayList<String>();
        @NotEmpty
        private String key = "objectType";
        @NotEmpty
        private String value = "Group";
        @NotEmpty
        private String objectIDKey = "objectId";

        public List<String> getAllowedGroups() {
            return this.allowedGroups;
        }

        public void setAllowedGroups(List<String> allowedGroups) {
            this.allowedGroups = allowedGroups;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getObjectIDKey() {
            return this.objectIDKey;
        }

        public void setObjectIDKey(String objectIDKey) {
            this.objectIDKey = objectIDKey;
        }

        public String toString() {
            return "UserGroupProperties{allowedGroups=" + this.allowedGroups + ", key='" + this.key + '\'' + ", value='" + this.value + '\'' + ", objectIDKey='" + this.objectIDKey + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserGroupProperties that = (UserGroupProperties)o;
            return Objects.equals(this.allowedGroups, that.allowedGroups) && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.objectIDKey, that.objectIDKey);
        }

        public int hashCode() {
            return Objects.hash(this.allowedGroups, this.key, this.value, this.objectIDKey);
        }
    }
}

