/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.microsoft.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.microsoft.azure.spring.autoconfigure.aad.AADOAuth2UserService;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpointsProperties;
import com.microsoft.azure.telemetry.TelemetryData;
import com.microsoft.azure.telemetry.TelemetrySender;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.userinfo.OAuth2UserService;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.util.ClassUtils;

@Configuration
@ConditionalOnResource(resources={"classpath:aad.enable.config"})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(prefix="azure.activedirectory", value={"tenant-id"})
@PropertySources(value={@PropertySource(value={"classpath:/aad-oauth2-common.properties"}), @PropertySource(value={"classpath:serviceEndpoints.properties"})})
@EnableConfigurationProperties(value={AADAuthenticationProperties.class, ServiceEndpointsProperties.class})
public class AADOAuth2AutoConfiguration {
    private final AADAuthenticationProperties aadAuthProps;
    private final ServiceEndpointsProperties serviceEndpointsProps;

    public AADOAuth2AutoConfiguration(AADAuthenticationProperties aadAuthProperties, ServiceEndpointsProperties serviceEndpointsProps) {
        this.aadAuthProps = aadAuthProperties;
        this.serviceEndpointsProps = serviceEndpointsProps;
    }

    @Bean
    @ConditionalOnProperty(prefix="azure.activedirectory.user-group", value={"allowed-groups"})
    public OAuth2UserService<OidcUserRequest, OidcUser> oidcUserService() {
        return new AADOAuth2UserService(this.aadAuthProps, this.serviceEndpointsProps);
    }

    @PostConstruct
    private void sendTelemetry() {
        if (this.aadAuthProps.isAllowTelemetry()) {
            HashMap<String, String> events = new HashMap<String, String>();
            TelemetrySender sender = new TelemetrySender();
            events.put("serviceName", TelemetryData.getClassPackageSimpleName(AADOAuth2AutoConfiguration.class));
            sender.send(ClassUtils.getUserClass(this.getClass()).getSimpleName(), events);
        }
    }
}

