/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.aad;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.aad.msal4j.IClientSecret;
import com.microsoft.aad.msal4j.MsalServiceException;
import com.microsoft.aad.msal4j.OnBehalfOfParameters;
import com.microsoft.aad.msal4j.UserAssertion;
import com.microsoft.azure.spring.autoconfigure.aad.AADAuthenticationProperties;
import com.microsoft.azure.spring.autoconfigure.aad.JacksonObjectMapperFactory;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpoints;
import com.microsoft.azure.spring.autoconfigure.aad.ServiceEndpointsProperties;
import com.microsoft.azure.spring.autoconfigure.aad.UserGroup;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.naming.ServiceUnavailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class AzureADGraphClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(AzureADGraphClient.class);
    private static final SimpleGrantedAuthority DEFAULT_AUTHORITY = new SimpleGrantedAuthority("ROLE_USER");
    private static final String DEFAULT_ROLE_PREFIX = "ROLE_";
    private static final String MICROSOFT_GRAPH_SCOPE = "https://graph.microsoft.com/user.read";
    private static final String AAD_GRAPH_API_SCOPE = "https://graph.windows.net/user.read";
    private static final String REQUEST_ID_SUFFIX = "aadfeed6";
    private final String clientId;
    private final String clientSecret;
    private final ServiceEndpoints serviceEndpoints;
    private final AADAuthenticationProperties aadAuthenticationProperties;
    private static final String V2_VERSION_ENV_FLAG = "v2-graph";
    private boolean aadMicrosoftGraphApiBool;

    public AzureADGraphClient(String clientId, String clientSecret, AADAuthenticationProperties aadAuthProps, ServiceEndpointsProperties serviceEndpointsProps) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.aadAuthenticationProperties = aadAuthProps;
        this.serviceEndpoints = serviceEndpointsProps.getServiceEndpoints(aadAuthProps.getEnvironment());
        this.initAADMicrosoftGraphApiBool(aadAuthProps.getEnvironment());
    }

    private void initAADMicrosoftGraphApiBool(String endpointEnv) {
        this.aadMicrosoftGraphApiBool = endpointEnv.contains(V2_VERSION_ENV_FLAG);
    }

    private String getUserMembershipsV1(String accessToken) throws IOException {
        URL url = new URL(this.serviceEndpoints.getAadMembershipRestUri());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (this.aadMicrosoftGraphApiBool) {
            conn.setRequestMethod(HttpMethod.GET.toString());
            conn.setRequestProperty("Authorization", String.format("Bearer %s", accessToken));
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        } else {
            conn.setRequestMethod(HttpMethod.GET.toString());
            conn.setRequestProperty("api-version", "1.6");
            conn.setRequestProperty("Authorization", String.format("Bearer %s", accessToken));
            conn.setRequestProperty("Accept", "application/json;odata=minimalmetadata");
        }
        String responseInJson = AzureADGraphClient.getResponseStringFromConn(conn);
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            return responseInJson;
        }
        throw new IllegalStateException("Response is not 200, response json: " + responseInJson);
    }

    private static String getResponseStringFromConn(HttpURLConnection conn) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            StringBuilder stringBuffer = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuffer.append(line);
            }
            String string = stringBuffer.toString();
            return string;
        }
    }

    public List<UserGroup> getGroups(String graphApiToken) throws IOException {
        return this.loadUserGroups(graphApiToken);
    }

    private List<UserGroup> loadUserGroups(String graphApiToken) throws IOException {
        String responseInJson = this.getUserMembershipsV1(graphApiToken);
        ArrayList<UserGroup> lUserGroups = new ArrayList<UserGroup>();
        ObjectMapper objectMapper = JacksonObjectMapperFactory.getInstance();
        JsonNode rootNode = (JsonNode)objectMapper.readValue(responseInJson, JsonNode.class);
        JsonNode valuesNode = rootNode.get("value");
        if (valuesNode != null) {
            lUserGroups.addAll(StreamSupport.stream(valuesNode.spliterator(), false).filter(this::isMatchingUserGroupKey).map(node -> {
                String objectID = node.get(this.aadAuthenticationProperties.getUserGroup().getObjectIDKey()).asText();
                String displayName = node.get("displayName").asText();
                return new UserGroup(objectID, displayName);
            }).collect(Collectors.toList()));
        }
        return lUserGroups;
    }

    private boolean isMatchingUserGroupKey(JsonNode node) {
        return node.get(this.aadAuthenticationProperties.getUserGroup().getKey()).asText().equals(this.aadAuthenticationProperties.getUserGroup().getValue());
    }

    public Set<GrantedAuthority> getGrantedAuthorities(String graphApiToken) throws IOException {
        List<UserGroup> groups = this.getGroups(graphApiToken);
        return this.convertGroupsToGrantedAuthorities(groups);
    }

    public Set<GrantedAuthority> convertGroupsToGrantedAuthorities(List<UserGroup> groups) {
        Set mappedAuthorities = groups.stream().filter(this::isValidUserGroupToGrantAuthority).map(userGroup -> new SimpleGrantedAuthority(DEFAULT_ROLE_PREFIX + userGroup.getDisplayName())).collect(Collectors.toCollection(LinkedHashSet::new));
        if (mappedAuthorities.isEmpty()) {
            mappedAuthorities.add(DEFAULT_AUTHORITY);
        }
        return mappedAuthorities;
    }

    private boolean isValidUserGroupToGrantAuthority(UserGroup group) {
        return this.aadAuthenticationProperties.getUserGroup().getAllowedGroups().contains(group.getDisplayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IAuthenticationResult acquireTokenForGraphApi(String idToken, String tenantId) throws ServiceUnavailableException {
        IClientSecret clientCredential = ClientCredentialFactory.createFromSecret((String)this.clientSecret);
        UserAssertion assertion = new UserAssertion(idToken);
        IAuthenticationResult result = null;
        ExecutorService service = null;
        try {
            service = Executors.newFixedThreadPool(1);
            ConfidentialClientApplication application = ((ConfidentialClientApplication.Builder)((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)clientCredential).authority(this.serviceEndpoints.getAadSigninUri() + tenantId + "/")).correlationId(AzureADGraphClient.getCorrelationId())).build();
            HashSet<String> scopes = new HashSet<String>();
            scopes.add(this.aadMicrosoftGraphApiBool ? MICROSOFT_GRAPH_SCOPE : AAD_GRAPH_API_SCOPE);
            OnBehalfOfParameters onBehalfOfParameters = OnBehalfOfParameters.builder(scopes, (UserAssertion)assertion).build();
            CompletableFuture future = application.acquireToken(onBehalfOfParameters);
            result = (IAuthenticationResult)future.get();
        }
        catch (InterruptedException | MalformedURLException | ExecutionException e) {
            MsalServiceException exception;
            Throwable cause = e.getCause();
            if (cause instanceof MsalServiceException && (exception = (MsalServiceException)cause).claims() != null && !exception.claims().isEmpty()) {
                throw exception;
            }
            LOGGER.error("acquire on behalf of token for graph api error", (Throwable)e);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
        if (result == null) {
            throw new ServiceUnavailableException("unable to acquire on-behalf-of token for client " + this.clientId);
        }
        return result;
    }

    private static String getCorrelationId() {
        String uuid = UUID.randomUUID().toString();
        return uuid.substring(0, uuid.length() - REQUEST_ID_SUFFIX.length()) + REQUEST_ID_SUFFIX;
    }
}

