/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.autoconfigure.jms;

import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactory;
import com.microsoft.azure.servicebus.jms.ServiceBusJmsConnectionFactorySettings;
import com.microsoft.azure.spring.autoconfigure.jms.AzureServiceBusJMSProperties;
import com.microsoft.azure.spring.autoconfigure.jms.SpringServiceBusJmsConnectionFactory;
import com.microsoft.azure.utils.ApplicationId;
import javax.jms.ConnectionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.config.DefaultJmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.listener.MessageListenerContainer;

@Configuration
@ConditionalOnClass(value={ServiceBusJmsConnectionFactory.class})
@ConditionalOnResource(resources={"classpath:servicebusjms.enable.config"})
@ConditionalOnProperty(value={"spring.jms.servicebus.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={AzureServiceBusJMSProperties.class})
public class ServiceBusJMSAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public ConnectionFactory jmsConnectionFactory(AzureServiceBusJMSProperties serviceBusJMSProperties) {
        String connectionString = serviceBusJMSProperties.getConnectionString();
        String clientID = serviceBusJMSProperties.getTopicClientId();
        long idleTimeout = serviceBusJMSProperties.getIdleTimeout();
        ServiceBusJmsConnectionFactorySettings settings = new ServiceBusJmsConnectionFactorySettings(idleTimeout, false);
        SpringServiceBusJmsConnectionFactory springServiceBusJmsConnectionFactory = new SpringServiceBusJmsConnectionFactory(connectionString, settings);
        springServiceBusJmsConnectionFactory.setClientId(clientID);
        springServiceBusJmsConnectionFactory.setCustomUserAgent(ApplicationId.AZURE_SPRING_SERVICE_BUS);
        return new CachingConnectionFactory((ConnectionFactory)springServiceBusJmsConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public JmsTemplate jmsTemplate(ConnectionFactory jmsConnectionFactory) {
        JmsTemplate jmsTemplate = new JmsTemplate();
        jmsTemplate.setConnectionFactory(jmsConnectionFactory);
        return jmsTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public JmsListenerContainerFactory<? extends MessageListenerContainer> jmsListenerContainerFactory(ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory jmsListenerContainerFactory = new DefaultJmsListenerContainerFactory();
        jmsListenerContainerFactory.setConnectionFactory(connectionFactory);
        return jmsListenerContainerFactory;
    }

    @Bean
    public JmsListenerContainerFactory<? extends MessageListenerContainer> topicJmsListenerContainerFactory(ConnectionFactory connectionFactory) {
        DefaultJmsListenerContainerFactory jmsListenerContainerFactory = new DefaultJmsListenerContainerFactory();
        jmsListenerContainerFactory.setConnectionFactory(connectionFactory);
        jmsListenerContainerFactory.setSubscriptionDurable(Boolean.TRUE);
        return jmsListenerContainerFactory;
    }
}

