/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sqldb.spark.bulkcopy;

import com.microsoft.azure.sqldb.spark.bulkcopy.ColumnMetadata;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;

public class BulkCopyMetadata
implements Serializable {
    private Map<Integer, ColumnMetadata> metadata = new HashMap<Integer, ColumnMetadata>();

    public void addColumnMetadata(int column, String name, int jdbcType, int precision, int scale) {
        this.addColumnMetadataInternal(column, name, jdbcType, precision, scale, null);
    }

    public void addColumnMetadata(int column, String name, int jdbcType, int precision, int scale, DateTimeFormatter dateTimeFormatter) {
        this.addColumnMetadataInternal(column, name, jdbcType, precision, scale, dateTimeFormatter);
    }

    Map<Integer, ColumnMetadata> getMetadata() {
        return this.metadata;
    }

    private void addColumnMetadataInternal(int column, String name, int jdbcType, int precision, int scale, DateTimeFormatter dateTimeFormatter) {
        switch (jdbcType) {
            case -155: 
            case 91: 
            case 92: 
            case 93: {
                this.metadata.put(column, new ColumnMetadata(name, jdbcType, 50, scale, dateTimeFormatter));
                break;
            }
            case 2009: {
                this.metadata.put(column, new ColumnMetadata(name, -16, precision, scale, dateTimeFormatter));
                break;
            }
            case 6: {
                this.metadata.put(column, new ColumnMetadata(name, 8, precision, scale, dateTimeFormatter));
                break;
            }
            case 16: {
                this.metadata.put(column, new ColumnMetadata(name, -7, precision, scale, dateTimeFormatter));
                break;
            }
            default: {
                this.metadata.put(column, new ColumnMetadata(name, jdbcType, precision, scale, dateTimeFormatter));
            }
        }
    }
}

