/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 * Changes may cause incorrect behavior and will be lost if the code is
 * regenerated.
 */

package com.microsoft.azure.storage;

import com.microsoft.rest.v2.RestProxy;
import com.microsoft.rest.v2.ServiceClient;
import com.microsoft.rest.v2.http.HttpPipeline;
import io.reactivex.annotations.NonNull;

/**
 * Initializes a new instance of the GeneratedStorageClient type.
 */
public final class GeneratedStorageClient extends ServiceClient {
    /**
     * The URL of the service account, container, or blob that is the targe of the desired operation.
     */
    private String url;

    /**
     * Gets The URL of the service account, container, or blob that is the targe of the desired operation.
     *
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Sets The URL of the service account, container, or blob that is the targe of the desired operation.
     *
     * @param url the url value.
     * @return the service client itself.
     */
    public GeneratedStorageClient withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Specifies the version of the operation to use for this request.
     */
    private String version;

    /**
     * Gets Specifies the version of the operation to use for this request.
     *
     * @return the version value.
     */
    public String version() {
        return this.version;
    }

    /**
     * Sets Specifies the version of the operation to use for this request.
     *
     * @param version the version value.
     * @return the service client itself.
     */
    public GeneratedStorageClient withVersion(String version) {
        this.version = version;
        return this;
    }

    /**
     * The GeneratedServices object to access its operations.
     */
    private GeneratedServices generatedServices;

    /**
     * Gets the GeneratedServices object to access its operations.
     *
     * @return the GeneratedServices object.
     */
    public GeneratedServices generatedServices() {
        return this.generatedServices;
    }

    /**
     * The GeneratedContainers object to access its operations.
     */
    private GeneratedContainers generatedContainers;

    /**
     * Gets the GeneratedContainers object to access its operations.
     *
     * @return the GeneratedContainers object.
     */
    public GeneratedContainers generatedContainers() {
        return this.generatedContainers;
    }

    /**
     * The GeneratedBlobs object to access its operations.
     */
    private GeneratedBlobs generatedBlobs;

    /**
     * Gets the GeneratedBlobs object to access its operations.
     *
     * @return the GeneratedBlobs object.
     */
    public GeneratedBlobs generatedBlobs() {
        return this.generatedBlobs;
    }

    /**
     * The GeneratedPageBlobs object to access its operations.
     */
    private GeneratedPageBlobs generatedPageBlobs;

    /**
     * Gets the GeneratedPageBlobs object to access its operations.
     *
     * @return the GeneratedPageBlobs object.
     */
    public GeneratedPageBlobs generatedPageBlobs() {
        return this.generatedPageBlobs;
    }

    /**
     * The GeneratedAppendBlobs object to access its operations.
     */
    private GeneratedAppendBlobs generatedAppendBlobs;

    /**
     * Gets the GeneratedAppendBlobs object to access its operations.
     *
     * @return the GeneratedAppendBlobs object.
     */
    public GeneratedAppendBlobs generatedAppendBlobs() {
        return this.generatedAppendBlobs;
    }

    /**
     * The GeneratedBlockBlobs object to access its operations.
     */
    private GeneratedBlockBlobs generatedBlockBlobs;

    /**
     * Gets the GeneratedBlockBlobs object to access its operations.
     *
     * @return the GeneratedBlockBlobs object.
     */
    public GeneratedBlockBlobs generatedBlockBlobs() {
        return this.generatedBlockBlobs;
    }

    /**
     * Initializes an instance of GeneratedStorageClient client.
     */
    public GeneratedStorageClient() {
        this(RestProxy.createDefaultPipeline());
    }

    /**
     * Initializes an instance of GeneratedStorageClient client.
     *
     * @param httpPipeline The HTTP pipeline to send requests through.
     */
    public GeneratedStorageClient(@NonNull HttpPipeline httpPipeline) {
        super(httpPipeline);
        this.generatedServices = new GeneratedServices(this);
        this.generatedContainers = new GeneratedContainers(this);
        this.generatedBlobs = new GeneratedBlobs(this);
        this.generatedPageBlobs = new GeneratedPageBlobs(this);
        this.generatedAppendBlobs = new GeneratedAppendBlobs(this);
        this.generatedBlockBlobs = new GeneratedBlockBlobs(this);
    }
}
