/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.GeneratedStorageClient;
import com.microsoft.azure.storage.blob.implementation.SignedIdentifiersWrapper;
import com.microsoft.azure.storage.blob.models.ContainersAcquireLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainersBreakLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainersChangeLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainersCreateResponse;
import com.microsoft.azure.storage.blob.models.ContainersDeleteResponse;
import com.microsoft.azure.storage.blob.models.ContainersGetAccessPolicyResponse;
import com.microsoft.azure.storage.blob.models.ContainersGetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.ContainersListBlobFlatSegmentResponse;
import com.microsoft.azure.storage.blob.models.ContainersListBlobHierarchySegmentResponse;
import com.microsoft.azure.storage.blob.models.ContainersReleaseLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainersRenewLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainersSetAccessPolicyResponse;
import com.microsoft.azure.storage.blob.models.ContainersSetMetadataResponse;
import com.microsoft.azure.storage.blob.models.ListBlobsFlatResponse;
import com.microsoft.azure.storage.blob.models.ListBlobsHierarchyResponse;
import com.microsoft.azure.storage.blob.models.ListBlobsIncludeItem;
import com.microsoft.azure.storage.blob.models.PublicAccessType;
import com.microsoft.azure.storage.blob.models.SignedIdentifier;
import com.microsoft.azure.storage.blob.models.StorageErrorException;
import com.microsoft.rest.v2.CollectionFormat;
import com.microsoft.rest.v2.DateTimeRfc1123;
import com.microsoft.rest.v2.RestProxy;
import com.microsoft.rest.v2.ServiceCallback;
import com.microsoft.rest.v2.ServiceClient;
import com.microsoft.rest.v2.ServiceFuture;
import com.microsoft.rest.v2.Validator;
import com.microsoft.rest.v2.annotations.BodyParam;
import com.microsoft.rest.v2.annotations.DELETE;
import com.microsoft.rest.v2.annotations.ExpectedResponses;
import com.microsoft.rest.v2.annotations.GET;
import com.microsoft.rest.v2.annotations.HeaderParam;
import com.microsoft.rest.v2.annotations.Host;
import com.microsoft.rest.v2.annotations.HostParam;
import com.microsoft.rest.v2.annotations.PUT;
import com.microsoft.rest.v2.annotations.QueryParam;
import com.microsoft.rest.v2.annotations.UnexpectedResponseExceptionType;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class GeneratedContainers {
    private ContainersService service;
    private GeneratedStorageClient client;

    public GeneratedContainers(GeneratedStorageClient client) {
        this.service = (ContainersService)RestProxy.create(ContainersService.class, (ServiceClient)client);
        this.client = client;
    }

    public void create(Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId) {
        this.createAsync(timeout, metadata, access, requestId).blockingAwait();
    }

    public ServiceFuture<Void> createAsync(Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.createAsync(timeout, metadata, access, requestId), serviceCallback);
    }

    public Single<ContainersCreateResponse> createWithRestResponseAsync(Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(metadata);
        return this.service.create(this.client.url(), timeout, metadata, access, this.client.version(), requestId, "container");
    }

    public Completable createAsync(Integer timeout, Map<String, String> metadata, PublicAccessType access, String requestId) {
        return this.createWithRestResponseAsync(timeout, metadata, access, requestId).toCompletable();
    }

    public void getProperties(Integer timeout, String leaseId, String requestId) {
        this.getPropertiesAsync(timeout, leaseId, requestId).blockingAwait();
    }

    public ServiceFuture<Void> getPropertiesAsync(Integer timeout, String leaseId, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.getPropertiesAsync(timeout, leaseId, requestId), serviceCallback);
    }

    public Single<ContainersGetPropertiesResponse> getPropertiesWithRestResponseAsync(Integer timeout, String leaseId, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        return this.service.getProperties(this.client.url(), timeout, leaseId, this.client.version(), requestId, "container");
    }

    public Completable getPropertiesAsync(Integer timeout, String leaseId, String requestId) {
        return this.getPropertiesWithRestResponseAsync(timeout, leaseId, requestId).toCompletable();
    }

    public void delete(Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        this.deleteAsync(timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, requestId).blockingAwait();
    }

    public ServiceFuture<Void> deleteAsync(Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.deleteAsync(timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, requestId), serviceCallback);
    }

    public Single<ContainersDeleteResponse> deleteWithRestResponseAsync(Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.delete(this.client.url(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.version(), requestId, "container");
    }

    public Completable deleteAsync(Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return this.deleteWithRestResponseAsync(timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, requestId).toCompletable();
    }

    public void setMetadata(Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId) {
        this.setMetadataAsync(timeout, leaseId, metadata, ifModifiedSince, requestId).blockingAwait();
    }

    public ServiceFuture<Void> setMetadataAsync(Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.setMetadataAsync(timeout, leaseId, metadata, ifModifiedSince, requestId), serviceCallback);
    }

    public Single<ContainersSetMetadataResponse> setMetadataWithRestResponseAsync(Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(metadata);
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        return this.service.setMetadata(this.client.url(), timeout, leaseId, metadata, ifModifiedSinceConverted, this.client.version(), requestId, "container", "metadata");
    }

    public Completable setMetadataAsync(Integer timeout, String leaseId, Map<String, String> metadata, OffsetDateTime ifModifiedSince, String requestId) {
        return this.setMetadataWithRestResponseAsync(timeout, leaseId, metadata, ifModifiedSince, requestId).toCompletable();
    }

    public List<SignedIdentifier> getAccessPolicy(Integer timeout, String leaseId, String requestId) {
        return (List)this.getAccessPolicyAsync(timeout, leaseId, requestId).blockingGet();
    }

    public ServiceFuture<List<SignedIdentifier>> getAccessPolicyAsync(Integer timeout, String leaseId, String requestId, ServiceCallback<List<SignedIdentifier>> serviceCallback) {
        return ServiceFuture.fromBody(this.getAccessPolicyAsync(timeout, leaseId, requestId), serviceCallback);
    }

    public Single<ContainersGetAccessPolicyResponse> getAccessPolicyWithRestResponseAsync(Integer timeout, String leaseId, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        return this.service.getAccessPolicy(this.client.url(), timeout, leaseId, this.client.version(), requestId, "container", "acl");
    }

    public Maybe<List<SignedIdentifier>> getAccessPolicyAsync(Integer timeout, String leaseId, String requestId) {
        return this.getAccessPolicyWithRestResponseAsync(timeout, leaseId, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    public void setAccessPolicy(List<SignedIdentifier> containerAcl, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        this.setAccessPolicyAsync(containerAcl, timeout, leaseId, access, ifModifiedSince, ifUnmodifiedSince, requestId).blockingAwait();
    }

    public ServiceFuture<Void> setAccessPolicyAsync(List<SignedIdentifier> containerAcl, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.setAccessPolicyAsync(containerAcl, timeout, leaseId, access, ifModifiedSince, ifUnmodifiedSince, requestId), serviceCallback);
    }

    public Single<ContainersSetAccessPolicyResponse> setAccessPolicyWithRestResponseAsync(List<SignedIdentifier> containerAcl, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(containerAcl);
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.setAccessPolicy(this.client.url(), new SignedIdentifiersWrapper(containerAcl), timeout, leaseId, access, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.version(), requestId, "container", "acl");
    }

    public Completable setAccessPolicyAsync(List<SignedIdentifier> containerAcl, Integer timeout, String leaseId, PublicAccessType access, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return this.setAccessPolicyWithRestResponseAsync(containerAcl, timeout, leaseId, access, ifModifiedSince, ifUnmodifiedSince, requestId).toCompletable();
    }

    public void acquireLease(Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        this.acquireLeaseAsync(timeout, duration, proposedLeaseId, ifModifiedSince, ifUnmodifiedSince, requestId).blockingAwait();
    }

    public ServiceFuture<Void> acquireLeaseAsync(Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.acquireLeaseAsync(timeout, duration, proposedLeaseId, ifModifiedSince, ifUnmodifiedSince, requestId), serviceCallback);
    }

    public Single<ContainersAcquireLeaseResponse> acquireLeaseWithRestResponseAsync(Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.acquireLease(this.client.url(), timeout, duration, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.version(), requestId, "lease", "container", "acquire");
    }

    public Completable acquireLeaseAsync(Integer timeout, Integer duration, String proposedLeaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return this.acquireLeaseWithRestResponseAsync(timeout, duration, proposedLeaseId, ifModifiedSince, ifUnmodifiedSince, requestId).toCompletable();
    }

    public void releaseLease(@NonNull String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        this.releaseLeaseAsync(leaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId).blockingAwait();
    }

    public ServiceFuture<Void> releaseLeaseAsync(@NonNull String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.releaseLeaseAsync(leaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId), serviceCallback);
    }

    public Single<ContainersReleaseLeaseResponse> releaseLeaseWithRestResponseAsync(@NonNull String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (leaseId == null) {
            throw new IllegalArgumentException("Parameter leaseId is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.releaseLease(this.client.url(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.version(), requestId, "lease", "container", "release");
    }

    public Completable releaseLeaseAsync(@NonNull String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return this.releaseLeaseWithRestResponseAsync(leaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId).toCompletable();
    }

    public void renewLease(@NonNull String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        this.renewLeaseAsync(leaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId).blockingAwait();
    }

    public ServiceFuture<Void> renewLeaseAsync(@NonNull String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.renewLeaseAsync(leaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId), serviceCallback);
    }

    public Single<ContainersRenewLeaseResponse> renewLeaseWithRestResponseAsync(@NonNull String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (leaseId == null) {
            throw new IllegalArgumentException("Parameter leaseId is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.renewLease(this.client.url(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.version(), requestId, "lease", "container", "renew");
    }

    public Completable renewLeaseAsync(@NonNull String leaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return this.renewLeaseWithRestResponseAsync(leaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId).toCompletable();
    }

    public void breakLease(Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        this.breakLeaseAsync(timeout, breakPeriod, ifModifiedSince, ifUnmodifiedSince, requestId).blockingAwait();
    }

    public ServiceFuture<Void> breakLeaseAsync(Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.breakLeaseAsync(timeout, breakPeriod, ifModifiedSince, ifUnmodifiedSince, requestId), serviceCallback);
    }

    public Single<ContainersBreakLeaseResponse> breakLeaseWithRestResponseAsync(Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.breakLease(this.client.url(), timeout, breakPeriod, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.version(), requestId, "lease", "container", "break");
    }

    public Completable breakLeaseAsync(Integer timeout, Integer breakPeriod, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return this.breakLeaseWithRestResponseAsync(timeout, breakPeriod, ifModifiedSince, ifUnmodifiedSince, requestId).toCompletable();
    }

    public void changeLease(@NonNull String leaseId, @NonNull String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        this.changeLeaseAsync(leaseId, proposedLeaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId).blockingAwait();
    }

    public ServiceFuture<Void> changeLeaseAsync(@NonNull String leaseId, @NonNull String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.changeLeaseAsync(leaseId, proposedLeaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId), serviceCallback);
    }

    public Single<ContainersChangeLeaseResponse> changeLeaseWithRestResponseAsync(@NonNull String leaseId, @NonNull String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (leaseId == null) {
            throw new IllegalArgumentException("Parameter leaseId is required and cannot be null.");
        }
        if (proposedLeaseId == null) {
            throw new IllegalArgumentException("Parameter proposedLeaseId is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.changeLease(this.client.url(), timeout, leaseId, proposedLeaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, this.client.version(), requestId, "lease", "container", "change");
    }

    public Completable changeLeaseAsync(@NonNull String leaseId, @NonNull String proposedLeaseId, Integer timeout, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String requestId) {
        return this.changeLeaseWithRestResponseAsync(leaseId, proposedLeaseId, timeout, ifModifiedSince, ifUnmodifiedSince, requestId).toCompletable();
    }

    public ListBlobsFlatResponse listBlobFlatSegment(String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return (ListBlobsFlatResponse)this.listBlobFlatSegmentAsync(prefix, marker, maxresults, include, timeout, requestId).blockingGet();
    }

    public ServiceFuture<ListBlobsFlatResponse> listBlobFlatSegmentAsync(String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, ServiceCallback<ListBlobsFlatResponse> serviceCallback) {
        return ServiceFuture.fromBody(this.listBlobFlatSegmentAsync(prefix, marker, maxresults, include, timeout, requestId), serviceCallback);
    }

    public Single<ContainersListBlobFlatSegmentResponse> listBlobFlatSegmentWithRestResponseAsync(String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(include);
        String includeConverted = this.client.serializerAdapter().serializeList(include, CollectionFormat.CSV);
        return this.service.listBlobFlatSegment(this.client.url(), prefix, marker, maxresults, includeConverted, timeout, this.client.version(), requestId, "container", "list");
    }

    public Maybe<ListBlobsFlatResponse> listBlobFlatSegmentAsync(String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return this.listBlobFlatSegmentWithRestResponseAsync(prefix, marker, maxresults, include, timeout, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    public ListBlobsHierarchyResponse listBlobHierarchySegment(@NonNull String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return (ListBlobsHierarchyResponse)this.listBlobHierarchySegmentAsync(delimiter, prefix, marker, maxresults, include, timeout, requestId).blockingGet();
    }

    public ServiceFuture<ListBlobsHierarchyResponse> listBlobHierarchySegmentAsync(@NonNull String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId, ServiceCallback<ListBlobsHierarchyResponse> serviceCallback) {
        return ServiceFuture.fromBody(this.listBlobHierarchySegmentAsync(delimiter, prefix, marker, maxresults, include, timeout, requestId), serviceCallback);
    }

    public Single<ContainersListBlobHierarchySegmentResponse> listBlobHierarchySegmentWithRestResponseAsync(@NonNull String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (delimiter == null) {
            throw new IllegalArgumentException("Parameter delimiter is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(include);
        String includeConverted = this.client.serializerAdapter().serializeList(include, CollectionFormat.CSV);
        return this.service.listBlobHierarchySegment(this.client.url(), prefix, delimiter, marker, maxresults, includeConverted, timeout, this.client.version(), requestId, "container", "list");
    }

    public Maybe<ListBlobsHierarchyResponse> listBlobHierarchySegmentAsync(@NonNull String delimiter, String prefix, String marker, Integer maxresults, List<ListBlobsIncludeItem> include, Integer timeout, String requestId) {
        return this.listBlobHierarchySegmentWithRestResponseAsync(delimiter, prefix, marker, maxresults, include, timeout, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    @Host(value="{url}")
    private static interface ContainersService {
        @PUT(value="{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainersCreateResponse> create(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-meta-") Map<String, String> var3, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="restype") String var7);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainersGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-lease-id") String var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6);

        @DELETE(value="{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainersDeleteResponse> delete(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-lease-id") String var3, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var4, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="restype") String var8);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainersSetMetadataResponse> setMetadata(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-lease-id") String var3, @HeaderParam(value="x-ms-meta-") Map<String, String> var4, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="restype") String var8, @QueryParam(value="comp") String var9);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainersGetAccessPolicyResponse> getAccessPolicy(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-lease-id") String var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainersSetAccessPolicyResponse> setAccessPolicy(@HostParam(value="url") String var1, @BodyParam(value="application/xml; charset=utf-8") SignedIdentifiersWrapper var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-lease-id") String var4, @HeaderParam(value="x-ms-blob-public-access") PublicAccessType var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @QueryParam(value="restype") String var10, @QueryParam(value="comp") String var11);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainersAcquireLeaseResponse> acquireLease(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-lease-duration") Integer var3, @HeaderParam(value="x-ms-proposed-lease-id") String var4, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var5, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, @QueryParam(value="restype") String var10, @HeaderParam(value="x-ms-lease-action") String var11);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainersReleaseLeaseResponse> releaseLease(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-lease-id") String var3, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var4, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @QueryParam(value="restype") String var9, @HeaderParam(value="x-ms-lease-action") String var10);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainersRenewLeaseResponse> renewLease(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-lease-id") String var3, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var4, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @QueryParam(value="restype") String var9, @HeaderParam(value="x-ms-lease-action") String var10);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainersBreakLeaseResponse> breakLease(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-lease-break-period") Integer var3, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var4, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, @QueryParam(value="comp") String var8, @QueryParam(value="restype") String var9, @HeaderParam(value="x-ms-lease-action") String var10);

        @PUT(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainersChangeLeaseResponse> changeLease(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-lease-id") String var3, @HeaderParam(value="x-ms-proposed-lease-id") String var4, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var5, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9, @QueryParam(value="restype") String var10, @HeaderParam(value="x-ms-lease-action") String var11);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainersListBlobFlatSegmentResponse> listBlobFlatSegment(@HostParam(value="url") String var1, @QueryParam(value="prefix") String var2, @QueryParam(value="marker") String var3, @QueryParam(value="maxresults") Integer var4, @QueryParam(value="include") String var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="restype") String var9, @QueryParam(value="comp") String var10);

        @GET(value="{containerName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ContainersListBlobHierarchySegmentResponse> listBlobHierarchySegment(@HostParam(value="url") String var1, @QueryParam(value="prefix") String var2, @QueryParam(value="delimiter") String var3, @QueryParam(value="marker") String var4, @QueryParam(value="maxresults") Integer var5, @QueryParam(value="include") String var6, @QueryParam(value="timeout") Integer var7, @HeaderParam(value="x-ms-version") String var8, @HeaderParam(value="x-ms-client-request-id") String var9, @QueryParam(value="restype") String var10, @QueryParam(value="comp") String var11);
    }
}

