/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.GeneratedStorageClient;
import com.microsoft.azure.storage.blob.models.PageBlobsClearPagesResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsCopyIncrementalResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsCreateResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsGetPageRangesDiffResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsGetPageRangesResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsResizeResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsUpdateSequenceNumberResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsUploadPagesResponse;
import com.microsoft.azure.storage.blob.models.PageList;
import com.microsoft.azure.storage.blob.models.SequenceNumberActionType;
import com.microsoft.azure.storage.blob.models.StorageErrorException;
import com.microsoft.rest.v2.DateTimeRfc1123;
import com.microsoft.rest.v2.RestProxy;
import com.microsoft.rest.v2.ServiceCallback;
import com.microsoft.rest.v2.ServiceClient;
import com.microsoft.rest.v2.ServiceFuture;
import com.microsoft.rest.v2.Validator;
import com.microsoft.rest.v2.annotations.BodyParam;
import com.microsoft.rest.v2.annotations.ExpectedResponses;
import com.microsoft.rest.v2.annotations.GET;
import com.microsoft.rest.v2.annotations.HeaderParam;
import com.microsoft.rest.v2.annotations.Host;
import com.microsoft.rest.v2.annotations.HostParam;
import com.microsoft.rest.v2.annotations.PUT;
import com.microsoft.rest.v2.annotations.QueryParam;
import com.microsoft.rest.v2.annotations.UnexpectedResponseExceptionType;
import com.microsoft.rest.v2.util.Base64Util;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;
import java.net.URL;
import java.nio.ByteBuffer;
import java.time.OffsetDateTime;
import java.util.Map;

public final class GeneratedPageBlobs {
    private PageBlobsService service;
    private GeneratedStorageClient client;

    public GeneratedPageBlobs(GeneratedStorageClient client) {
        this.service = (PageBlobsService)RestProxy.create(PageBlobsService.class, (ServiceClient)client);
        this.client = client;
    }

    public void create(@NonNull long contentLength, Integer timeout, String blobContentType, String blobContentEncoding, String blobContentLanguage, byte[] blobContentMD5, String blobCacheControl, Map<String, String> metadata, String leaseId, String blobContentDisposition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, Long blobContentLength, Long blobSequenceNumber, String requestId) {
        this.createAsync(contentLength, timeout, blobContentType, blobContentEncoding, blobContentLanguage, blobContentMD5, blobCacheControl, metadata, leaseId, blobContentDisposition, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, blobContentLength, blobSequenceNumber, requestId).blockingAwait();
    }

    public ServiceFuture<Void> createAsync(@NonNull long contentLength, Integer timeout, String blobContentType, String blobContentEncoding, String blobContentLanguage, byte[] blobContentMD5, String blobCacheControl, Map<String, String> metadata, String leaseId, String blobContentDisposition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, Long blobContentLength, Long blobSequenceNumber, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.createAsync(contentLength, timeout, blobContentType, blobContentEncoding, blobContentLanguage, blobContentMD5, blobCacheControl, metadata, leaseId, blobContentDisposition, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, blobContentLength, blobSequenceNumber, requestId), serviceCallback);
    }

    public Single<PageBlobsCreateResponse> createWithRestResponseAsync(@NonNull long contentLength, Integer timeout, String blobContentType, String blobContentEncoding, String blobContentLanguage, byte[] blobContentMD5, String blobCacheControl, Map<String, String> metadata, String leaseId, String blobContentDisposition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, Long blobContentLength, Long blobSequenceNumber, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(metadata);
        String blobContentMD5Converted = Base64Util.encodeToString((byte[])blobContentMD5);
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.create(this.client.url(), timeout, contentLength, blobContentType, blobContentEncoding, blobContentLanguage, blobContentMD5Converted, blobCacheControl, metadata, leaseId, blobContentDisposition, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatches, ifNoneMatch, blobContentLength, blobSequenceNumber, this.client.version(), requestId, "PageBlob");
    }

    public Completable createAsync(@NonNull long contentLength, Integer timeout, String blobContentType, String blobContentEncoding, String blobContentLanguage, byte[] blobContentMD5, String blobCacheControl, Map<String, String> metadata, String leaseId, String blobContentDisposition, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, Long blobContentLength, Long blobSequenceNumber, String requestId) {
        return this.createWithRestResponseAsync(contentLength, timeout, blobContentType, blobContentEncoding, blobContentLanguage, blobContentMD5, blobCacheControl, metadata, leaseId, blobContentDisposition, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, blobContentLength, blobSequenceNumber, requestId).toCompletable();
    }

    public void uploadPages(@NonNull Flowable<ByteBuffer> body, @NonNull long contentLength, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        this.uploadPagesAsync(body, contentLength, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId).blockingAwait();
    }

    public ServiceFuture<Void> uploadPagesAsync(@NonNull Flowable<ByteBuffer> body, @NonNull long contentLength, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.uploadPagesAsync(body, contentLength, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId), serviceCallback);
    }

    public Single<PageBlobsUploadPagesResponse> uploadPagesWithRestResponseAsync(@NonNull Flowable<ByteBuffer> body, @NonNull long contentLength, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (body == null) {
            throw new IllegalArgumentException("Parameter body is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.uploadPages(this.client.url(), body, contentLength, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatches, ifNoneMatch, this.client.version(), requestId, "page", "update");
    }

    public Completable uploadPagesAsync(@NonNull Flowable<ByteBuffer> body, @NonNull long contentLength, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        return this.uploadPagesWithRestResponseAsync(body, contentLength, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId).toCompletable();
    }

    public void clearPages(@NonNull long contentLength, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        this.clearPagesAsync(contentLength, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId).blockingAwait();
    }

    public ServiceFuture<Void> clearPagesAsync(@NonNull long contentLength, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.clearPagesAsync(contentLength, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId), serviceCallback);
    }

    public Single<PageBlobsClearPagesResponse> clearPagesWithRestResponseAsync(@NonNull long contentLength, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.clearPages(this.client.url(), contentLength, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatches, ifNoneMatch, this.client.version(), requestId, "page", "clear");
    }

    public Completable clearPagesAsync(@NonNull long contentLength, Integer timeout, String range, String leaseId, Long ifSequenceNumberLessThanOrEqualTo, Long ifSequenceNumberLessThan, Long ifSequenceNumberEqualTo, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        return this.clearPagesWithRestResponseAsync(contentLength, timeout, range, leaseId, ifSequenceNumberLessThanOrEqualTo, ifSequenceNumberLessThan, ifSequenceNumberEqualTo, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId).toCompletable();
    }

    public PageList getPageRanges(String snapshot, Integer timeout, String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        return (PageList)this.getPageRangesAsync(snapshot, timeout, range, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId).blockingGet();
    }

    public ServiceFuture<PageList> getPageRangesAsync(String snapshot, Integer timeout, String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId, ServiceCallback<PageList> serviceCallback) {
        return ServiceFuture.fromBody(this.getPageRangesAsync(snapshot, timeout, range, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId), serviceCallback);
    }

    public Single<PageBlobsGetPageRangesResponse> getPageRangesWithRestResponseAsync(String snapshot, Integer timeout, String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.getPageRanges(this.client.url(), snapshot, timeout, range, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatches, ifNoneMatch, this.client.version(), requestId, "pagelist");
    }

    public Maybe<PageList> getPageRangesAsync(String snapshot, Integer timeout, String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        return this.getPageRangesWithRestResponseAsync(snapshot, timeout, range, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    public PageList getPageRangesDiff(String snapshot, Integer timeout, String prevsnapshot, String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        return (PageList)this.getPageRangesDiffAsync(snapshot, timeout, prevsnapshot, range, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId).blockingGet();
    }

    public ServiceFuture<PageList> getPageRangesDiffAsync(String snapshot, Integer timeout, String prevsnapshot, String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId, ServiceCallback<PageList> serviceCallback) {
        return ServiceFuture.fromBody(this.getPageRangesDiffAsync(snapshot, timeout, prevsnapshot, range, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId), serviceCallback);
    }

    public Single<PageBlobsGetPageRangesDiffResponse> getPageRangesDiffWithRestResponseAsync(String snapshot, Integer timeout, String prevsnapshot, String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.getPageRangesDiff(this.client.url(), snapshot, timeout, prevsnapshot, range, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatches, ifNoneMatch, this.client.version(), requestId, "pagelist");
    }

    public Maybe<PageList> getPageRangesDiffAsync(String snapshot, Integer timeout, String prevsnapshot, String range, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        return this.getPageRangesDiffWithRestResponseAsync(snapshot, timeout, prevsnapshot, range, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    public void resize(@NonNull long blobContentLength, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        this.resizeAsync(blobContentLength, timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId).blockingAwait();
    }

    public ServiceFuture<Void> resizeAsync(@NonNull long blobContentLength, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.resizeAsync(blobContentLength, timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId), serviceCallback);
    }

    public Single<PageBlobsResizeResponse> resizeWithRestResponseAsync(@NonNull long blobContentLength, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.resize(this.client.url(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatches, ifNoneMatch, blobContentLength, this.client.version(), requestId, "properties");
    }

    public Completable resizeAsync(@NonNull long blobContentLength, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        return this.resizeWithRestResponseAsync(blobContentLength, timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId).toCompletable();
    }

    public void updateSequenceNumber(@NonNull SequenceNumberActionType sequenceNumberAction, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, Long blobSequenceNumber, String requestId) {
        this.updateSequenceNumberAsync(sequenceNumberAction, timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, blobSequenceNumber, requestId).blockingAwait();
    }

    public ServiceFuture<Void> updateSequenceNumberAsync(@NonNull SequenceNumberActionType sequenceNumberAction, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, Long blobSequenceNumber, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.updateSequenceNumberAsync(sequenceNumberAction, timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, blobSequenceNumber, requestId), serviceCallback);
    }

    public Single<PageBlobsUpdateSequenceNumberResponse> updateSequenceNumberWithRestResponseAsync(@NonNull SequenceNumberActionType sequenceNumberAction, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, Long blobSequenceNumber, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (sequenceNumberAction == null) {
            throw new IllegalArgumentException("Parameter sequenceNumberAction is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.updateSequenceNumber(this.client.url(), timeout, leaseId, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatches, ifNoneMatch, sequenceNumberAction, blobSequenceNumber, this.client.version(), requestId, "properties");
    }

    public Completable updateSequenceNumberAsync(@NonNull SequenceNumberActionType sequenceNumberAction, Integer timeout, String leaseId, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, Long blobSequenceNumber, String requestId) {
        return this.updateSequenceNumberWithRestResponseAsync(sequenceNumberAction, timeout, leaseId, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, blobSequenceNumber, requestId).toCompletable();
    }

    public void copyIncremental(@NonNull URL copySource, Integer timeout, Map<String, String> metadata, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        this.copyIncrementalAsync(copySource, timeout, metadata, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId).blockingAwait();
    }

    public ServiceFuture<Void> copyIncrementalAsync(@NonNull URL copySource, Integer timeout, Map<String, String> metadata, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.copyIncrementalAsync(copySource, timeout, metadata, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId), serviceCallback);
    }

    public Single<PageBlobsCopyIncrementalResponse> copyIncrementalWithRestResponseAsync(@NonNull URL copySource, Integer timeout, Map<String, String> metadata, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (copySource == null) {
            throw new IllegalArgumentException("Parameter copySource is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate(metadata);
        Validator.validate((Object)copySource);
        DateTimeRfc1123 ifModifiedSinceConverted = null;
        if (ifModifiedSince != null) {
            ifModifiedSinceConverted = new DateTimeRfc1123(ifModifiedSince);
        }
        DateTimeRfc1123 ifUnmodifiedSinceConverted = null;
        if (ifUnmodifiedSince != null) {
            ifUnmodifiedSinceConverted = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this.service.copyIncremental(this.client.url(), timeout, metadata, ifModifiedSinceConverted, ifUnmodifiedSinceConverted, ifMatches, ifNoneMatch, copySource, this.client.version(), requestId, "incrementalcopy");
    }

    public Completable copyIncrementalAsync(@NonNull URL copySource, Integer timeout, Map<String, String> metadata, OffsetDateTime ifModifiedSince, OffsetDateTime ifUnmodifiedSince, String ifMatches, String ifNoneMatch, String requestId) {
        return this.copyIncrementalWithRestResponseAsync(copySource, timeout, metadata, ifModifiedSince, ifUnmodifiedSince, ifMatches, ifNoneMatch, requestId).toCompletable();
    }

    @Host(value="{url}")
    private static interface PageBlobsService {
        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<PageBlobsCreateResponse> create(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="Content-Length") long var3, @HeaderParam(value="x-ms-blob-content-type") String var5, @HeaderParam(value="x-ms-blob-content-encoding") String var6, @HeaderParam(value="x-ms-blob-content-language") String var7, @HeaderParam(value="x-ms-blob-content-md5") String var8, @HeaderParam(value="x-ms-blob-cache-control") String var9, @HeaderParam(value="x-ms-meta-") Map<String, String> var10, @HeaderParam(value="x-ms-lease-id") String var11, @HeaderParam(value="x-ms-blob-content-disposition") String var12, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var13, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var14, @HeaderParam(value="If-Match") String var15, @HeaderParam(value="If-None-Match") String var16, @HeaderParam(value="x-ms-blob-content-length") Long var17, @HeaderParam(value="x-ms-blob-sequence-number") Long var18, @HeaderParam(value="x-ms-version") String var19, @HeaderParam(value="x-ms-client-request-id") String var20, @HeaderParam(value="x-ms-blob-type") String var21);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<PageBlobsUploadPagesResponse> uploadPages(@HostParam(value="url") String var1, @BodyParam(value="application/octet-stream") Flowable<ByteBuffer> var2, @HeaderParam(value="Content-Length") long var3, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-range") String var6, @HeaderParam(value="x-ms-lease-id") String var7, @HeaderParam(value="x-ms-if-sequence-number-le") Long var8, @HeaderParam(value="x-ms-if-sequence-number-lt") Long var9, @HeaderParam(value="x-ms-if-sequence-number-eq") Long var10, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var12, @HeaderParam(value="If-Match") String var13, @HeaderParam(value="If-None-Match") String var14, @HeaderParam(value="x-ms-version") String var15, @HeaderParam(value="x-ms-client-request-id") String var16, @QueryParam(value="comp") String var17, @HeaderParam(value="x-ms-page-write") String var18);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<PageBlobsClearPagesResponse> clearPages(@HostParam(value="url") String var1, @HeaderParam(value="Content-Length") long var2, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-range") String var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="x-ms-if-sequence-number-le") Long var7, @HeaderParam(value="x-ms-if-sequence-number-lt") Long var8, @HeaderParam(value="x-ms-if-sequence-number-eq") Long var9, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var10, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var11, @HeaderParam(value="If-Match") String var12, @HeaderParam(value="If-None-Match") String var13, @HeaderParam(value="x-ms-version") String var14, @HeaderParam(value="x-ms-client-request-id") String var15, @QueryParam(value="comp") String var16, @HeaderParam(value="x-ms-page-write") String var17);

        @GET(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<PageBlobsGetPageRangesResponse> getPageRanges(@HostParam(value="url") String var1, @QueryParam(value="snapshot") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-range") String var4, @HeaderParam(value="x-ms-lease-id") String var5, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var6, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Match") String var8, @HeaderParam(value="If-None-Match") String var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @QueryParam(value="comp") String var12);

        @GET(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<PageBlobsGetPageRangesDiffResponse> getPageRangesDiff(@HostParam(value="url") String var1, @QueryParam(value="snapshot") String var2, @QueryParam(value="timeout") Integer var3, @QueryParam(value="prevsnapshot") String var4, @HeaderParam(value="x-ms-range") String var5, @HeaderParam(value="x-ms-lease-id") String var6, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var7, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var8, @HeaderParam(value="If-Match") String var9, @HeaderParam(value="If-None-Match") String var10, @HeaderParam(value="x-ms-version") String var11, @HeaderParam(value="x-ms-client-request-id") String var12, @QueryParam(value="comp") String var13);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<PageBlobsResizeResponse> resize(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-lease-id") String var3, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var4, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="x-ms-blob-content-length") long var8, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @QueryParam(value="comp") String var12);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<PageBlobsUpdateSequenceNumberResponse> updateSequenceNumber(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-lease-id") String var3, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var4, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="x-ms-sequence-number-action") SequenceNumberActionType var8, @HeaderParam(value="x-ms-blob-sequence-number") Long var9, @HeaderParam(value="x-ms-version") String var10, @HeaderParam(value="x-ms-client-request-id") String var11, @QueryParam(value="comp") String var12);

        @PUT(value="{containerName}/{blob}")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<PageBlobsCopyIncrementalResponse> copyIncremental(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-meta-") Map<String, String> var3, @HeaderParam(value="If-Modified-Since") DateTimeRfc1123 var4, @HeaderParam(value="If-Unmodified-Since") DateTimeRfc1123 var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="x-ms-copy-source") URL var8, @HeaderParam(value="x-ms-version") String var9, @HeaderParam(value="x-ms-client-request-id") String var10, @QueryParam(value="comp") String var11);
    }
}

