/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.GeneratedStorageClient;
import com.microsoft.azure.storage.blob.models.ListContainersIncludeType;
import com.microsoft.azure.storage.blob.models.ListContainersResponse;
import com.microsoft.azure.storage.blob.models.ServiceGetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.ServiceGetStatisticsResponse;
import com.microsoft.azure.storage.blob.models.ServiceListContainersSegmentResponse;
import com.microsoft.azure.storage.blob.models.ServiceSetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.StorageErrorException;
import com.microsoft.azure.storage.blob.models.StorageServiceProperties;
import com.microsoft.azure.storage.blob.models.StorageServiceStats;
import com.microsoft.rest.v2.RestProxy;
import com.microsoft.rest.v2.ServiceCallback;
import com.microsoft.rest.v2.ServiceClient;
import com.microsoft.rest.v2.ServiceFuture;
import com.microsoft.rest.v2.Validator;
import com.microsoft.rest.v2.annotations.BodyParam;
import com.microsoft.rest.v2.annotations.ExpectedResponses;
import com.microsoft.rest.v2.annotations.GET;
import com.microsoft.rest.v2.annotations.HeaderParam;
import com.microsoft.rest.v2.annotations.Host;
import com.microsoft.rest.v2.annotations.HostParam;
import com.microsoft.rest.v2.annotations.PUT;
import com.microsoft.rest.v2.annotations.QueryParam;
import com.microsoft.rest.v2.annotations.UnexpectedResponseExceptionType;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.annotations.NonNull;

public final class GeneratedServices {
    private ServicesService service;
    private GeneratedStorageClient client;

    public GeneratedServices(GeneratedStorageClient client) {
        this.service = (ServicesService)RestProxy.create(ServicesService.class, (ServiceClient)client);
        this.client = client;
    }

    public void setProperties(@NonNull StorageServiceProperties storageServiceProperties, Integer timeout, String requestId) {
        this.setPropertiesAsync(storageServiceProperties, timeout, requestId).blockingAwait();
    }

    public ServiceFuture<Void> setPropertiesAsync(@NonNull StorageServiceProperties storageServiceProperties, Integer timeout, String requestId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromBody((Completable)this.setPropertiesAsync(storageServiceProperties, timeout, requestId), serviceCallback);
    }

    public Single<ServiceSetPropertiesResponse> setPropertiesWithRestResponseAsync(@NonNull StorageServiceProperties storageServiceProperties, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (storageServiceProperties == null) {
            throw new IllegalArgumentException("Parameter storageServiceProperties is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        Validator.validate((Object)storageServiceProperties);
        return this.service.setProperties(this.client.url(), storageServiceProperties, timeout, this.client.version(), requestId, "service", "properties");
    }

    public Completable setPropertiesAsync(@NonNull StorageServiceProperties storageServiceProperties, Integer timeout, String requestId) {
        return this.setPropertiesWithRestResponseAsync(storageServiceProperties, timeout, requestId).toCompletable();
    }

    public StorageServiceProperties getProperties(Integer timeout, String requestId) {
        return (StorageServiceProperties)this.getPropertiesAsync(timeout, requestId).blockingGet();
    }

    public ServiceFuture<StorageServiceProperties> getPropertiesAsync(Integer timeout, String requestId, ServiceCallback<StorageServiceProperties> serviceCallback) {
        return ServiceFuture.fromBody(this.getPropertiesAsync(timeout, requestId), serviceCallback);
    }

    public Single<ServiceGetPropertiesResponse> getPropertiesWithRestResponseAsync(Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        return this.service.getProperties(this.client.url(), timeout, this.client.version(), requestId, "service", "properties");
    }

    public Maybe<StorageServiceProperties> getPropertiesAsync(Integer timeout, String requestId) {
        return this.getPropertiesWithRestResponseAsync(timeout, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    public StorageServiceStats getStatistics(Integer timeout, String requestId) {
        return (StorageServiceStats)this.getStatisticsAsync(timeout, requestId).blockingGet();
    }

    public ServiceFuture<StorageServiceStats> getStatisticsAsync(Integer timeout, String requestId, ServiceCallback<StorageServiceStats> serviceCallback) {
        return ServiceFuture.fromBody(this.getStatisticsAsync(timeout, requestId), serviceCallback);
    }

    public Single<ServiceGetStatisticsResponse> getStatisticsWithRestResponseAsync(Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        return this.service.getStatistics(this.client.url(), timeout, this.client.version(), requestId, "service", "stats");
    }

    public Maybe<StorageServiceStats> getStatisticsAsync(Integer timeout, String requestId) {
        return this.getStatisticsWithRestResponseAsync(timeout, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    public ListContainersResponse listContainersSegment(String prefix, String marker, Integer maxresults, ListContainersIncludeType include, Integer timeout, String requestId) {
        return (ListContainersResponse)this.listContainersSegmentAsync(prefix, marker, maxresults, include, timeout, requestId).blockingGet();
    }

    public ServiceFuture<ListContainersResponse> listContainersSegmentAsync(String prefix, String marker, Integer maxresults, ListContainersIncludeType include, Integer timeout, String requestId, ServiceCallback<ListContainersResponse> serviceCallback) {
        return ServiceFuture.fromBody(this.listContainersSegmentAsync(prefix, marker, maxresults, include, timeout, requestId), serviceCallback);
    }

    public Single<ServiceListContainersSegmentResponse> listContainersSegmentWithRestResponseAsync(String prefix, String marker, Integer maxresults, ListContainersIncludeType include, Integer timeout, String requestId) {
        if (this.client.url() == null) {
            throw new IllegalArgumentException("Parameter this.client.url() is required and cannot be null.");
        }
        if (this.client.version() == null) {
            throw new IllegalArgumentException("Parameter this.client.version() is required and cannot be null.");
        }
        return this.service.listContainersSegment(this.client.url(), prefix, marker, maxresults, include, timeout, this.client.version(), requestId, "list");
    }

    public Maybe<ListContainersResponse> listContainersSegmentAsync(String prefix, String marker, Integer maxresults, ListContainersIncludeType include, Integer timeout, String requestId) {
        return this.listContainersSegmentWithRestResponseAsync(prefix, marker, maxresults, include, timeout, requestId).flatMapMaybe(res -> res.body() == null ? Maybe.empty() : Maybe.just((Object)res.body()));
    }

    @Host(value="{url}")
    private static interface ServicesService {
        @PUT(value="")
        @ExpectedResponses(value={202})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ServiceSetPropertiesResponse> setProperties(@HostParam(value="url") String var1, @BodyParam(value="application/xml; charset=utf-8") StorageServiceProperties var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, @QueryParam(value="restype") String var6, @QueryParam(value="comp") String var7);

        @GET(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ServiceGetPropertiesResponse> getProperties(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="comp") String var6);

        @GET(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ServiceGetStatisticsResponse> getStatistics(@HostParam(value="url") String var1, @QueryParam(value="timeout") Integer var2, @HeaderParam(value="x-ms-version") String var3, @HeaderParam(value="x-ms-client-request-id") String var4, @QueryParam(value="restype") String var5, @QueryParam(value="comp") String var6);

        @GET(value="")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=StorageErrorException.class)
        public Single<ServiceListContainersSegmentResponse> listContainersSegment(@HostParam(value="url") String var1, @QueryParam(value="prefix") String var2, @QueryParam(value="marker") String var3, @QueryParam(value="maxresults") Integer var4, @QueryParam(value="include") ListContainersIncludeType var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, @QueryParam(value="comp") String var9);
    }
}

