/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import java.util.Locale;

public final class AccountSASPermission {
    public boolean read;
    public boolean add;
    public boolean create;
    public boolean write;
    public boolean delete;
    public boolean list;
    public boolean update;
    public boolean processMessages;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.read) {
            builder.append('r');
        }
        if (this.write) {
            builder.append('w');
        }
        if (this.delete) {
            builder.append('d');
        }
        if (this.list) {
            builder.append('l');
        }
        if (this.add) {
            builder.append('a');
        }
        if (this.create) {
            builder.append('c');
        }
        if (this.update) {
            builder.append('u');
        }
        if (this.processMessages) {
            builder.append('p');
        }
        return builder.toString();
    }

    public static AccountSASPermission parse(String permString) {
        AccountSASPermission permissions = new AccountSASPermission();
        int i = 0;
        while (i < permString.length()) {
            char c = permString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.read = true;
                    break;
                }
                case 'w': {
                    permissions.write = true;
                    break;
                }
                case 'd': {
                    permissions.delete = true;
                    break;
                }
                case 'l': {
                    permissions.list = true;
                    break;
                }
                case 'a': {
                    permissions.add = true;
                    break;
                }
                case 'c': {
                    permissions.create = true;
                    break;
                }
                case 'u': {
                    permissions.update = true;
                    break;
                }
                case 'p': {
                    permissions.processMessages = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permString, Character.valueOf(c)));
                }
            }
            ++i;
        }
        return permissions;
    }
}

