/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import java.util.Locale;

public final class AccountSASResourceType {
    public boolean service;
    public boolean container;
    public boolean object;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.service) {
            builder.append('s');
        }
        if (this.container) {
            builder.append('c');
        }
        if (this.object) {
            builder.append('o');
        }
        return builder.toString();
    }

    public static AccountSASResourceType parse(String resourceTypesString) {
        AccountSASResourceType resourceType = new AccountSASResourceType();
        int i = 0;
        while (i < resourceTypesString.length()) {
            char c = resourceTypesString.charAt(i);
            switch (c) {
                case 's': {
                    resourceType.service = true;
                    break;
                }
                case 'c': {
                    resourceType.container = true;
                    break;
                }
                case 'o': {
                    resourceType.object = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Resource Types", resourceTypesString, Character.valueOf(c)));
                }
            }
            ++i;
        }
        return resourceType;
    }
}

