/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import java.util.Locale;

public final class AccountSASService {
    public boolean blob;
    public boolean file;
    public boolean queue;
    public boolean table;

    public String toString() {
        StringBuilder value = new StringBuilder();
        if (this.blob) {
            value.append('b');
        }
        if (this.queue) {
            value.append('q');
        }
        if (this.table) {
            value.append('t');
        }
        if (this.file) {
            value.append('f');
        }
        return value.toString();
    }

    public static AccountSASService parse(String servicesString) {
        AccountSASService services = new AccountSASService();
        int i = 0;
        while (i < servicesString.length()) {
            char c = servicesString.charAt(i);
            switch (c) {
                case 'b': {
                    services.blob = true;
                    break;
                }
                case 'f': {
                    services.file = true;
                    break;
                }
                case 'q': {
                    services.queue = true;
                    break;
                }
                case 't': {
                    services.table = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Services", servicesString, Character.valueOf(c)));
                }
            }
            ++i;
        }
        return services;
    }
}

