/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.AccountSASPermission;
import com.microsoft.azure.storage.blob.IPRange;
import com.microsoft.azure.storage.blob.SASProtocol;
import com.microsoft.azure.storage.blob.SASQueryParameters;
import com.microsoft.azure.storage.blob.SharedKeyCredentials;
import com.microsoft.azure.storage.blob.Utility;
import java.security.InvalidKeyException;
import java.time.OffsetDateTime;

public final class AccountSASSignatureValues {
    public String version = "2017-07-29";
    public SASProtocol protocol;
    public OffsetDateTime startTime;
    public OffsetDateTime expiryTime;
    public String permissions;
    public IPRange ipRange;
    public String services;
    public String resourceTypes;

    public SASQueryParameters generateSASQueryParameters(SharedKeyCredentials sharedKeyCredentials) {
        String signature;
        Utility.assertNotNull("SharedKeyCredentials", sharedKeyCredentials);
        Utility.assertNotNull("services", this.services);
        Utility.assertNotNull("resourceTypes", this.resourceTypes);
        Utility.assertNotNull("expiryTime", this.expiryTime);
        Utility.assertNotNull("permissions", this.permissions);
        String stringToSign = String.join((CharSequence)"\n", sharedKeyCredentials.getAccountName(), AccountSASPermission.parse(this.permissions).toString(), this.services, this.resourceTypes, this.startTime == null ? "" : Utility.ISO8601UTCDateFormatter.format(this.startTime), this.expiryTime == null ? "" : Utility.ISO8601UTCDateFormatter.format(this.expiryTime), this.ipRange == null ? IPRange.DEFAULT.toString() : this.ipRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version, "");
        try {
            signature = sharedKeyCredentials.computeHmac256(stringToSign);
        }
        catch (InvalidKeyException e) {
            throw new Error(e);
        }
        return new SASQueryParameters(this.version, this.services, this.resourceTypes, this.protocol, this.startTime, this.expiryTime, this.ipRange, null, null, this.permissions, signature);
    }
}

