/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobHTTPHeaders;
import com.microsoft.azure.storage.blob.BlobURL;
import com.microsoft.azure.storage.blob.BlobURLParts;
import com.microsoft.azure.storage.blob.Metadata;
import com.microsoft.azure.storage.blob.URLParser;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.AppendBlobsAppendBlockResponse;
import com.microsoft.azure.storage.blob.models.AppendBlobsCreateResponse;
import com.microsoft.rest.v2.http.HttpPipeline;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public final class AppendBlobURL
extends BlobURL {
    public static final int MAX_APPEND_BLOCK_BYTES = 0x400000;
    public static final int MAX_BLOCKS = 50000;

    public AppendBlobURL(URL url, HttpPipeline pipeline) {
        super(url, pipeline);
    }

    @Override
    public AppendBlobURL withPipeline(HttpPipeline pipeline) {
        try {
            return new AppendBlobURL(new URL(this.storageClient.url()), pipeline);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public AppendBlobURL withSnapshot(String snapshot) throws MalformedURLException, UnknownHostException {
        BlobURLParts blobURLParts = URLParser.parse(new URL(this.storageClient.url()));
        blobURLParts.snapshot = snapshot;
        return new AppendBlobURL(blobURLParts.toURL(), this.storageClient.httpPipeline());
    }

    public Single<AppendBlobsCreateResponse> create(BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions) {
        headers = headers == null ? BlobHTTPHeaders.NONE : headers;
        metadata = metadata == null ? Metadata.NONE : metadata;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedAppendBlobs().createWithRestResponseAsync(0L, null, headers.getContentType(), headers.getContentEncoding(), headers.getContentLanguage(), headers.getContentMD5(), headers.getCacheControl(), metadata, accessConditions.getLeaseAccessConditions().getLeaseId(), headers.getContentDisposition(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null));
    }

    public Single<AppendBlobsAppendBlockResponse> appendBlock(Flowable<ByteBuffer> data, long length, BlobAccessConditions accessConditions) {
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedAppendBlobs().appendBlockWithRestResponseAsync(data, length, null, accessConditions.getLeaseAccessConditions().getLeaseId(), accessConditions.getAppendBlobAccessConditions().getIfMaxSizeLessThanOrEqual(), accessConditions.getAppendBlobAccessConditions().getIfAppendPositionEquals(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null));
    }
}

