/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.models.ListBlobsIncludeItem;
import java.util.ArrayList;

public final class BlobListingDetails {
    public static final BlobListingDetails NONE = new BlobListingDetails(false, false, false, false);
    private final boolean copy;
    private final boolean metadata;
    private final boolean snapshots;
    private final boolean uncommittedBlobs;

    public BlobListingDetails(boolean copy, boolean metadata, boolean snapshots, boolean uncommittedBlobs) {
        this.copy = copy;
        this.metadata = metadata;
        this.snapshots = snapshots;
        this.uncommittedBlobs = uncommittedBlobs;
    }

    public boolean getCopy() {
        return this.copy;
    }

    public boolean getMetadata() {
        return this.metadata;
    }

    public boolean getSnapshots() {
        return this.snapshots;
    }

    public boolean getUncommittedBlobs() {
        return this.uncommittedBlobs;
    }

    ArrayList<ListBlobsIncludeItem> toList() {
        ArrayList<ListBlobsIncludeItem> details = new ArrayList<ListBlobsIncludeItem>();
        if (this.copy) {
            details.add(ListBlobsIncludeItem.COPY);
        }
        if (this.metadata) {
            details.add(ListBlobsIncludeItem.METADATA);
        }
        if (this.snapshots) {
            details.add(ListBlobsIncludeItem.SNAPSHOTS);
        }
        if (this.uncommittedBlobs) {
            details.add(ListBlobsIncludeItem.UNCOMMITTEDBLOBS);
        }
        return details;
    }
}

