/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import java.util.Locale;

public final class BlobRange {
    public static final BlobRange DEFAULT = new BlobRange(0L, null);
    private final long offset;
    private final Long count;

    public BlobRange(long offset, Long count) {
        if (offset < 0L) {
            throw new IllegalArgumentException("BlobRange offset must be greater than or equal to 0.");
        }
        if (count != null && count < 0L) {
            throw new IllegalArgumentException("BlobRange count must be greater than or equal to 0 if specified. Cannot be specified without an offset.");
        }
        this.offset = offset;
        this.count = count;
    }

    public long getOffset() {
        return this.offset;
    }

    public Long getCount() {
        return this.count;
    }

    public String toString() {
        if (this.count != null) {
            long rangeEnd = this.offset + this.count - 1L;
            return String.format(Locale.ROOT, "bytes=%d-%d", this.offset, rangeEnd);
        }
        return String.format(Locale.ROOT, "bytes=%d-", this.offset);
    }
}

