/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.AppendBlobURL;
import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobHTTPHeaders;
import com.microsoft.azure.storage.blob.BlobRange;
import com.microsoft.azure.storage.blob.BlobURLParts;
import com.microsoft.azure.storage.blob.BlockBlobURL;
import com.microsoft.azure.storage.blob.DownloadResponse;
import com.microsoft.azure.storage.blob.HTTPAccessConditions;
import com.microsoft.azure.storage.blob.LeaseAccessConditions;
import com.microsoft.azure.storage.blob.Metadata;
import com.microsoft.azure.storage.blob.PageBlobURL;
import com.microsoft.azure.storage.blob.StorageURL;
import com.microsoft.azure.storage.blob.URLParser;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.BlobsAbortCopyFromURLResponse;
import com.microsoft.azure.storage.blob.models.BlobsAcquireLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobsBreakLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobsChangeLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobsCreateSnapshotResponse;
import com.microsoft.azure.storage.blob.models.BlobsDeleteResponse;
import com.microsoft.azure.storage.blob.models.BlobsGetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.BlobsReleaseLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobsRenewLeaseResponse;
import com.microsoft.azure.storage.blob.models.BlobsSetHTTPHeadersResponse;
import com.microsoft.azure.storage.blob.models.BlobsSetMetadataResponse;
import com.microsoft.azure.storage.blob.models.BlobsStartCopyFromURLResponse;
import com.microsoft.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.microsoft.rest.v2.http.HttpPipeline;
import io.reactivex.Single;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class BlobURL
extends StorageURL {
    public BlobURL(URL url, HttpPipeline pipeline) {
        super(url, pipeline);
    }

    public BlobURL withPipeline(HttpPipeline pipeline) {
        try {
            return new BlobURL(new URL(this.storageClient.url()), pipeline);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public BlobURL withSnapshot(String snapshot) throws MalformedURLException, UnknownHostException {
        BlobURLParts blobURLParts = URLParser.parse(new URL(this.storageClient.url()));
        blobURLParts.snapshot = snapshot;
        return new BlobURL(blobURLParts.toURL(), this.storageClient.httpPipeline());
    }

    public BlockBlobURL toBlockBlobURL() {
        try {
            return new BlockBlobURL(new URL(this.storageClient.url()), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public AppendBlobURL toAppendBlobURL() {
        try {
            return new AppendBlobURL(new URL(this.storageClient.url()), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public PageBlobURL toPageBlobURL() {
        try {
            return new PageBlobURL(new URL(this.storageClient.url()), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public Single<BlobsStartCopyFromURLResponse> startCopyFromURL(URL sourceURL, Metadata metadata, BlobAccessConditions sourceAccessConditions, BlobAccessConditions destAccessConditions) {
        metadata = metadata == null ? Metadata.NONE : metadata;
        sourceAccessConditions = sourceAccessConditions == null ? BlobAccessConditions.NONE : sourceAccessConditions;
        destAccessConditions = destAccessConditions == null ? BlobAccessConditions.NONE : destAccessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlobs().startCopyFromURLWithRestResponseAsync(sourceURL, null, metadata, sourceAccessConditions.getHttpAccessConditions().getIfModifiedSince(), sourceAccessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), sourceAccessConditions.getHttpAccessConditions().getIfMatch().toString(), sourceAccessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), destAccessConditions.getHttpAccessConditions().getIfModifiedSince(), destAccessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), destAccessConditions.getHttpAccessConditions().getIfMatch().toString(), destAccessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), destAccessConditions.getLeaseAccessConditions().getLeaseId(), sourceAccessConditions.getLeaseAccessConditions().getLeaseId(), null));
    }

    public Single<BlobsAbortCopyFromURLResponse> abortCopyFromURL(String copyId, LeaseAccessConditions leaseAccessConditions) {
        leaseAccessConditions = leaseAccessConditions == null ? LeaseAccessConditions.NONE : leaseAccessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlobs().abortCopyFromURLWithRestResponseAsync(copyId, null, leaseAccessConditions.getLeaseId(), null));
    }

    public Single<DownloadResponse> download(BlobRange range, BlobAccessConditions accessConditions, boolean rangeGetContentMD5) {
        Boolean getMD5 = rangeGetContentMD5 ? Boolean.valueOf(rangeGetContentMD5) : null;
        range = range == null ? BlobRange.DEFAULT : range;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlobs().downloadWithRestResponseAsync(null, null, range.toString(), accessConditions.getLeaseAccessConditions().getLeaseId(), getMD5, accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null)).map(response -> new DownloadResponse(response.statusCode(), response.headers(), response.rawHeaders(), response.body()));
    }

    public Single<BlobsDeleteResponse> delete(DeleteSnapshotsOptionType deleteBlobSnapshotOptions, BlobAccessConditions accessConditions) {
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlobs().deleteWithRestResponseAsync(null, null, accessConditions.getLeaseAccessConditions().getLeaseId(), deleteBlobSnapshotOptions, accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null));
    }

    public Single<BlobsGetPropertiesResponse> getProperties(BlobAccessConditions accessConditions) {
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlobs().getPropertiesWithRestResponseAsync(null, null, accessConditions.getLeaseAccessConditions().getLeaseId(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null));
    }

    public Single<BlobsSetHTTPHeadersResponse> setHTTPHeaders(BlobHTTPHeaders headers, BlobAccessConditions accessConditions) {
        headers = headers == null ? BlobHTTPHeaders.NONE : headers;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlobs().setHTTPHeadersWithRestResponseAsync(null, headers.getCacheControl(), headers.getContentType(), headers.getContentMD5(), headers.getContentEncoding(), headers.getContentLanguage(), accessConditions.getLeaseAccessConditions().getLeaseId(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), headers.getContentDisposition(), null));
    }

    public Single<BlobsSetMetadataResponse> setMetadata(Metadata metadata, BlobAccessConditions accessConditions) {
        metadata = metadata == null ? Metadata.NONE : metadata;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlobs().setMetadataWithRestResponseAsync(null, metadata, accessConditions.getLeaseAccessConditions().getLeaseId(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null));
    }

    public Single<BlobsCreateSnapshotResponse> createSnapshot(Metadata metadata, BlobAccessConditions accessConditions) {
        metadata = metadata == null ? Metadata.NONE : metadata;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlobs().createSnapshotWithRestResponseAsync(null, metadata, accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), accessConditions.getLeaseAccessConditions().getLeaseId(), null));
    }

    public Single<BlobsAcquireLeaseResponse> acquireLease(String proposedID, int duration, HTTPAccessConditions httpAccessConditions) {
        HTTPAccessConditions hTTPAccessConditions = httpAccessConditions = httpAccessConditions == null ? HTTPAccessConditions.NONE : httpAccessConditions;
        if (duration != -1 && (duration < 15 || duration > 60)) {
            throw new IllegalArgumentException("Duration must be -1 or between 15 and 60.");
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlobs().acquireLeaseWithRestResponseAsync(null, duration, proposedID, httpAccessConditions.getIfModifiedSince(), httpAccessConditions.getIfUnmodifiedSince(), httpAccessConditions.getIfMatch().toString(), httpAccessConditions.getIfNoneMatch().toString(), null));
    }

    public Single<BlobsRenewLeaseResponse> renewLease(String leaseID, HTTPAccessConditions httpAccessConditions) {
        httpAccessConditions = httpAccessConditions == null ? HTTPAccessConditions.NONE : httpAccessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlobs().renewLeaseWithRestResponseAsync(leaseID, null, httpAccessConditions.getIfModifiedSince(), httpAccessConditions.getIfUnmodifiedSince(), httpAccessConditions.getIfMatch().toString(), httpAccessConditions.getIfNoneMatch().toString(), null));
    }

    public Single<BlobsReleaseLeaseResponse> releaseLease(String leaseID, HTTPAccessConditions httpAccessConditions) {
        httpAccessConditions = httpAccessConditions == null ? HTTPAccessConditions.NONE : httpAccessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlobs().releaseLeaseWithRestResponseAsync(leaseID, null, httpAccessConditions.getIfModifiedSince(), httpAccessConditions.getIfUnmodifiedSince(), httpAccessConditions.getIfMatch().toString(), httpAccessConditions.getIfNoneMatch().toString(), null));
    }

    public Single<BlobsBreakLeaseResponse> breakLease(Integer breakPeriodInSeconds, HTTPAccessConditions httpAccessConditions) {
        httpAccessConditions = httpAccessConditions == null ? HTTPAccessConditions.NONE : httpAccessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlobs().breakLeaseWithRestResponseAsync(null, breakPeriodInSeconds, httpAccessConditions.getIfModifiedSince(), httpAccessConditions.getIfUnmodifiedSince(), httpAccessConditions.getIfMatch().toString(), httpAccessConditions.getIfNoneMatch().toString(), null));
    }

    public Single<BlobsChangeLeaseResponse> changeLease(String leaseId, String proposedID, HTTPAccessConditions httpAccessConditions) {
        httpAccessConditions = httpAccessConditions == null ? HTTPAccessConditions.NONE : httpAccessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlobs().changeLeaseWithRestResponseAsync(leaseId, proposedID, null, httpAccessConditions.getIfModifiedSince(), httpAccessConditions.getIfUnmodifiedSince(), httpAccessConditions.getIfMatch().toString(), httpAccessConditions.getIfNoneMatch().toString(), null));
    }
}

