/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.SASQueryParameters;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.rest.v2.http.UrlBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public final class BlobURLParts {
    public String scheme;
    public String host;
    public String containerName;
    public String blobName;
    public String snapshot;
    public SASQueryParameters sasQueryParameters;
    public Map<String, String[]> unparsedParameters = new HashMap<String, String[]>();

    public URL toURL() throws MalformedURLException {
        String encodedSAS;
        UrlBuilder url = new UrlBuilder().withScheme(this.scheme).withHost(this.host);
        StringBuilder path = new StringBuilder();
        if (this.containerName != null) {
            path.append(this.containerName);
            if (this.blobName != null) {
                path.append('/');
                path.append(this.blobName);
            }
        }
        url.withPath(path.toString());
        if (this.snapshot != null) {
            url.setQueryParameter("snapshot", this.snapshot);
        }
        if (this.sasQueryParameters != null && (encodedSAS = this.sasQueryParameters.encode()).length() != 0) {
            url.withQuery(encodedSAS);
        }
        for (Map.Entry<String, String[]> entry : this.unparsedParameters.entrySet()) {
            url.setQueryParameter(entry.getKey(), Utility.safeURLEncode(String.join((CharSequence)",", entry.getValue())));
        }
        return url.toURL();
    }
}

