/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobHTTPHeaders;
import com.microsoft.azure.storage.blob.BlobURL;
import com.microsoft.azure.storage.blob.BlobURLParts;
import com.microsoft.azure.storage.blob.LeaseAccessConditions;
import com.microsoft.azure.storage.blob.Metadata;
import com.microsoft.azure.storage.blob.URLParser;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.BlockBlobsCommitBlockListResponse;
import com.microsoft.azure.storage.blob.models.BlockBlobsGetBlockListResponse;
import com.microsoft.azure.storage.blob.models.BlockBlobsStageBlockResponse;
import com.microsoft.azure.storage.blob.models.BlockBlobsUploadResponse;
import com.microsoft.azure.storage.blob.models.BlockListType;
import com.microsoft.azure.storage.blob.models.BlockLookupList;
import com.microsoft.rest.v2.http.HttpPipeline;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.List;

public final class BlockBlobURL
extends BlobURL {
    public static final int MAX_PUT_BLOB_BYTES = 0x10000000;
    public static final int MAX_PUT_BLOCK_BYTES = 0x6400000;
    public static final int MAX_BLOCKS = 50000;

    public BlockBlobURL(URL url, HttpPipeline pipeline) {
        super(url, pipeline);
    }

    @Override
    public BlockBlobURL withPipeline(HttpPipeline pipeline) {
        try {
            return new BlockBlobURL(new URL(this.storageClient.url()), pipeline);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public BlockBlobURL withSnapshot(String snapshot) throws MalformedURLException, UnknownHostException {
        BlobURLParts blobURLParts = URLParser.parse(new URL(this.storageClient.url()));
        blobURLParts.snapshot = snapshot;
        return new BlockBlobURL(blobURLParts.toURL(), this.storageClient.httpPipeline());
    }

    public Single<BlockBlobsUploadResponse> upload(Flowable<ByteBuffer> data, long length, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions) {
        headers = headers == null ? BlobHTTPHeaders.NONE : headers;
        metadata = metadata == null ? Metadata.NONE : metadata;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlockBlobs().uploadWithRestResponseAsync(data, length, null, headers.getContentType(), headers.getContentEncoding(), headers.getContentLanguage(), headers.getContentMD5(), headers.getCacheControl(), metadata, accessConditions.getLeaseAccessConditions().getLeaseId(), headers.getContentDisposition(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null));
    }

    public Single<BlockBlobsStageBlockResponse> stageBlock(String base64BlockID, Flowable<ByteBuffer> data, long length, LeaseAccessConditions leaseAccessConditions) {
        leaseAccessConditions = leaseAccessConditions == null ? LeaseAccessConditions.NONE : leaseAccessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlockBlobs().stageBlockWithRestResponseAsync(base64BlockID, length, data, null, leaseAccessConditions.getLeaseId(), null));
    }

    public Single<BlockBlobsGetBlockListResponse> getBlockList(BlockListType listType, LeaseAccessConditions leaseAccessConditions) {
        leaseAccessConditions = leaseAccessConditions == null ? LeaseAccessConditions.NONE : leaseAccessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlockBlobs().getBlockListWithRestResponseAsync(listType, null, null, leaseAccessConditions.getLeaseId(), null));
    }

    public Single<BlockBlobsCommitBlockListResponse> commitBlockList(List<String> base64BlockIDs, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions) {
        headers = headers == null ? BlobHTTPHeaders.NONE : headers;
        metadata = metadata == null ? Metadata.NONE : metadata;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedBlockBlobs().commitBlockListWithRestResponseAsync(new BlockLookupList().withLatest(base64BlockIDs), null, headers.getCacheControl(), headers.getContentType(), headers.getContentEncoding(), headers.getContentLanguage(), headers.getContentMD5(), metadata, accessConditions.getLeaseAccessConditions().getLeaseId(), headers.getContentDisposition(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null));
    }
}

