/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import java.util.Locale;

public final class ContainerSASPermission {
    public boolean read;
    public boolean add;
    public boolean create;
    public boolean write;
    public boolean delete;
    public boolean list;

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.read) {
            builder.append('r');
        }
        if (this.add) {
            builder.append('a');
        }
        if (this.create) {
            builder.append('c');
        }
        if (this.write) {
            builder.append('w');
        }
        if (this.delete) {
            builder.append('d');
        }
        if (this.list) {
            builder.append('l');
        }
        return builder.toString();
    }

    public static ContainerSASPermission parse(String permString) {
        ContainerSASPermission permissions = new ContainerSASPermission();
        int i = 0;
        while (i < permString.length()) {
            char c = permString.charAt(i);
            switch (c) {
                case 'r': {
                    permissions.read = true;
                    break;
                }
                case 'a': {
                    permissions.add = true;
                    break;
                }
                case 'c': {
                    permissions.create = true;
                    break;
                }
                case 'w': {
                    permissions.write = true;
                    break;
                }
                case 'd': {
                    permissions.delete = true;
                    break;
                }
                case 'l': {
                    permissions.list = true;
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "%s could not be parsed from '%s' due to invalid value %s.", "Permissions", permString, Character.valueOf(c)));
                }
            }
            ++i;
        }
        return permissions;
    }
}

