/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.AppendBlobURL;
import com.microsoft.azure.storage.blob.BlobURL;
import com.microsoft.azure.storage.blob.BlockBlobURL;
import com.microsoft.azure.storage.blob.ContainerAccessConditions;
import com.microsoft.azure.storage.blob.ETag;
import com.microsoft.azure.storage.blob.HTTPAccessConditions;
import com.microsoft.azure.storage.blob.LeaseAccessConditions;
import com.microsoft.azure.storage.blob.ListBlobsOptions;
import com.microsoft.azure.storage.blob.Metadata;
import com.microsoft.azure.storage.blob.PageBlobURL;
import com.microsoft.azure.storage.blob.StorageURL;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.ContainersAcquireLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainersBreakLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainersChangeLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainersCreateResponse;
import com.microsoft.azure.storage.blob.models.ContainersDeleteResponse;
import com.microsoft.azure.storage.blob.models.ContainersGetAccessPolicyResponse;
import com.microsoft.azure.storage.blob.models.ContainersGetPropertiesResponse;
import com.microsoft.azure.storage.blob.models.ContainersListBlobFlatSegmentResponse;
import com.microsoft.azure.storage.blob.models.ContainersListBlobHierarchySegmentResponse;
import com.microsoft.azure.storage.blob.models.ContainersReleaseLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainersRenewLeaseResponse;
import com.microsoft.azure.storage.blob.models.ContainersSetAccessPolicyResponse;
import com.microsoft.azure.storage.blob.models.ContainersSetMetadataResponse;
import com.microsoft.azure.storage.blob.models.PublicAccessType;
import com.microsoft.azure.storage.blob.models.SignedIdentifier;
import com.microsoft.rest.v2.http.HttpPipeline;
import io.reactivex.Single;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.temporal.ChronoUnit;
import java.util.List;

public final class ContainerURL
extends StorageURL {
    public ContainerURL(URL url, HttpPipeline pipeline) {
        super(url, pipeline);
    }

    public ContainerURL withPipeline(HttpPipeline pipeline) {
        try {
            return new ContainerURL(new URL(this.storageClient.url()), pipeline);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public BlockBlobURL createBlockBlobURL(String blobName) {
        blobName = Utility.safeURLEncode(blobName);
        try {
            return new BlockBlobURL(StorageURL.appendToURLPath(new URL(this.storageClient.url()), blobName), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public PageBlobURL createPageBlobURL(String blobName) {
        blobName = Utility.safeURLEncode(blobName);
        try {
            return new PageBlobURL(StorageURL.appendToURLPath(new URL(this.storageClient.url()), blobName), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public AppendBlobURL createAppendBlobURL(String blobName) {
        blobName = Utility.safeURLEncode(blobName);
        try {
            return new AppendBlobURL(StorageURL.appendToURLPath(new URL(this.storageClient.url()), blobName), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public BlobURL createBlobURL(String blobName) {
        blobName = Utility.safeURLEncode(blobName);
        try {
            return new BlobURL(StorageURL.appendToURLPath(new URL(this.storageClient.url()), blobName), this.storageClient.httpPipeline());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public Single<ContainersCreateResponse> create(Metadata metadata, PublicAccessType accessType) {
        metadata = metadata == null ? Metadata.NONE : metadata;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedContainers().createWithRestResponseAsync(null, metadata, accessType, null));
    }

    public Single<ContainersDeleteResponse> delete(ContainerAccessConditions accessConditions) {
        ContainerAccessConditions containerAccessConditions = accessConditions = accessConditions == null ? ContainerAccessConditions.NONE : accessConditions;
        if (!accessConditions.getHttpAccessConditions().getIfMatch().equals(ETag.NONE) || !accessConditions.getHttpAccessConditions().getIfNoneMatch().equals(ETag.NONE)) {
            throw new IllegalArgumentException("ETag access conditions are not supported for this API.");
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedContainers().deleteWithRestResponseAsync(null, accessConditions.getLeaseAccessConditions().getLeaseId(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), null));
    }

    public Single<ContainersGetPropertiesResponse> getProperties(LeaseAccessConditions leaseAccessConditions) {
        leaseAccessConditions = leaseAccessConditions == null ? LeaseAccessConditions.NONE : leaseAccessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedContainers().getPropertiesWithRestResponseAsync(null, leaseAccessConditions.getLeaseId(), null));
    }

    public Single<ContainersSetMetadataResponse> setMetadata(Metadata metadata, ContainerAccessConditions accessConditions) {
        metadata = metadata == null ? Metadata.NONE : metadata;
        ContainerAccessConditions containerAccessConditions = accessConditions = accessConditions == null ? ContainerAccessConditions.NONE : accessConditions;
        if (accessConditions.getHttpAccessConditions().getIfMatch() != ETag.NONE || accessConditions.getHttpAccessConditions().getIfNoneMatch() != ETag.NONE || accessConditions.getHttpAccessConditions().getIfUnmodifiedSince() != null) {
            throw new IllegalArgumentException("If-Modified-Since is the only HTTP access condition supported for this API");
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedContainers().setMetadataWithRestResponseAsync(null, accessConditions.getLeaseAccessConditions().getLeaseId(), metadata, accessConditions.getHttpAccessConditions().getIfModifiedSince(), null));
    }

    public Single<ContainersGetAccessPolicyResponse> getAccessPolicy(LeaseAccessConditions leaseAccessConditions) {
        leaseAccessConditions = leaseAccessConditions == null ? LeaseAccessConditions.NONE : leaseAccessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedContainers().getAccessPolicyWithRestResponseAsync(null, leaseAccessConditions.getLeaseId(), null));
    }

    public Single<ContainersSetAccessPolicyResponse> setAccessPolicy(PublicAccessType accessType, List<SignedIdentifier> identifiers, ContainerAccessConditions accessConditions) {
        ContainerAccessConditions containerAccessConditions = accessConditions = accessConditions == null ? ContainerAccessConditions.NONE : accessConditions;
        if (identifiers != null) {
            for (SignedIdentifier identifier : identifiers) {
                if (identifier.accessPolicy() != null && identifier.accessPolicy().start() != null) {
                    identifier.accessPolicy().withStart(identifier.accessPolicy().start().truncatedTo(ChronoUnit.SECONDS));
                }
                if (identifier.accessPolicy() == null || identifier.accessPolicy().expiry() == null) continue;
                identifier.accessPolicy().withExpiry(identifier.accessPolicy().expiry().truncatedTo(ChronoUnit.SECONDS));
            }
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedContainers().setAccessPolicyWithRestResponseAsync(identifiers, null, accessConditions.getLeaseAccessConditions().getLeaseId(), accessType, accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), null));
    }

    private boolean validateLeaseOperationAccessConditions(HTTPAccessConditions httpAccessConditions) {
        return httpAccessConditions.getIfMatch() == ETag.NONE && httpAccessConditions.getIfNoneMatch() == ETag.NONE;
    }

    public Single<ContainersAcquireLeaseResponse> acquireLease(String proposedID, int duration, HTTPAccessConditions httpAccessConditions) {
        HTTPAccessConditions hTTPAccessConditions = httpAccessConditions = httpAccessConditions == null ? HTTPAccessConditions.NONE : httpAccessConditions;
        if (!this.validateLeaseOperationAccessConditions(httpAccessConditions)) {
            throw new IllegalArgumentException("ETag access conditions are not supported for this API.");
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedContainers().acquireLeaseWithRestResponseAsync(null, duration, proposedID, httpAccessConditions.getIfModifiedSince(), httpAccessConditions.getIfUnmodifiedSince(), null));
    }

    public Single<ContainersRenewLeaseResponse> renewLease(String leaseID, HTTPAccessConditions httpAccessConditions) {
        HTTPAccessConditions hTTPAccessConditions = httpAccessConditions = httpAccessConditions == null ? HTTPAccessConditions.NONE : httpAccessConditions;
        if (!this.validateLeaseOperationAccessConditions(httpAccessConditions)) {
            throw new IllegalArgumentException("ETag access conditions are not supported for this API.");
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedContainers().renewLeaseWithRestResponseAsync(leaseID, null, httpAccessConditions.getIfModifiedSince(), httpAccessConditions.getIfUnmodifiedSince(), null));
    }

    public Single<ContainersReleaseLeaseResponse> releaseLease(String leaseID, HTTPAccessConditions httpAccessConditions) {
        HTTPAccessConditions hTTPAccessConditions = httpAccessConditions = httpAccessConditions == null ? HTTPAccessConditions.NONE : httpAccessConditions;
        if (!this.validateLeaseOperationAccessConditions(httpAccessConditions)) {
            throw new IllegalArgumentException("ETag access conditions are not supported for this API.");
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedContainers().releaseLeaseWithRestResponseAsync(leaseID, null, httpAccessConditions.getIfModifiedSince(), httpAccessConditions.getIfUnmodifiedSince(), null));
    }

    public Single<ContainersBreakLeaseResponse> breakLease(Integer breakPeriodInSeconds, HTTPAccessConditions httpAccessConditions) {
        HTTPAccessConditions hTTPAccessConditions = httpAccessConditions = httpAccessConditions == null ? HTTPAccessConditions.NONE : httpAccessConditions;
        if (!this.validateLeaseOperationAccessConditions(httpAccessConditions)) {
            throw new IllegalArgumentException("ETag access conditions are not supported for this API.");
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedContainers().breakLeaseWithRestResponseAsync(null, breakPeriodInSeconds, httpAccessConditions.getIfModifiedSince(), httpAccessConditions.getIfUnmodifiedSince(), null));
    }

    public Single<ContainersChangeLeaseResponse> changeLease(String leaseID, String proposedID, HTTPAccessConditions httpAccessConditions) {
        HTTPAccessConditions hTTPAccessConditions = httpAccessConditions = httpAccessConditions == null ? HTTPAccessConditions.NONE : httpAccessConditions;
        if (!this.validateLeaseOperationAccessConditions(httpAccessConditions)) {
            throw new IllegalArgumentException("ETag access conditions are not supported for this API.");
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedContainers().changeLeaseWithRestResponseAsync(leaseID, proposedID, null, httpAccessConditions.getIfModifiedSince(), httpAccessConditions.getIfUnmodifiedSince(), null));
    }

    public Single<ContainersListBlobFlatSegmentResponse> listBlobsFlatSegment(String marker, ListBlobsOptions options) {
        options = options == null ? ListBlobsOptions.DEFAULT : options;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedContainers().listBlobFlatSegmentWithRestResponseAsync(options.getPrefix(), marker, options.getMaxResults(), options.getDetails().toList(), null, null));
    }

    public Single<ContainersListBlobHierarchySegmentResponse> listBlobsHierarchySegment(String marker, String delimiter, ListBlobsOptions options) {
        ListBlobsOptions listBlobsOptions = options = options == null ? ListBlobsOptions.DEFAULT : options;
        if (options.getDetails().getSnapshots()) {
            throw new IllegalArgumentException("Including snapshots in a hierarchical listing is not supported.");
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedContainers().listBlobHierarchySegmentWithRestResponseAsync(delimiter, options.getPrefix(), marker, options.getMaxResults(), options.getDetails().toList(), null, null));
    }
}

