/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobRange;
import com.microsoft.azure.storage.blob.BlobURL;
import com.microsoft.azure.storage.blob.HTTPAccessConditions;
import com.microsoft.azure.storage.blob.RetryReader;
import com.microsoft.azure.storage.blob.RetryReaderOptions;
import com.microsoft.azure.storage.blob.models.BlobsDownloadHeaders;
import com.microsoft.rest.v2.RestResponse;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.internal.functions.Functions;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Map;

public class DownloadResponse
extends RestResponse<BlobsDownloadHeaders, Flowable<ByteBuffer>>
implements Closeable {
    private BlobURL blobURL;
    private RetryReader.HTTPGetterInfo info;

    DownloadResponse(int statusCode, BlobsDownloadHeaders blobsDownloadHeaders, Map<String, String> rawHeaders, Flowable<ByteBuffer> byteBufferFlowable) {
        super(statusCode, (Object)blobsDownloadHeaders, rawHeaders, byteBufferFlowable);
    }

    public Flowable<ByteBuffer> body(RetryReaderOptions options) {
        RetryReaderOptions retryReaderOptions = options = options == null ? new RetryReaderOptions() : options;
        if (options.maxRetryRequests == 0) {
            return (Flowable)super.body();
        }
        return new RetryReader(Single.just((Object)this), this.info, options, newInfo -> this.blobURL.download(new BlobRange(newInfo.offset, newInfo.count), new BlobAccessConditions(new HTTPAccessConditions(null, null, this.info.eTag, null), null, null, null), false));
    }

    public int statusCode() {
        return super.statusCode();
    }

    public BlobsDownloadHeaders headers() {
        return (BlobsDownloadHeaders)super.headers();
    }

    public Map<String, String> rawHeaders() {
        return super.rawHeaders();
    }

    public Flowable<ByteBuffer> body() {
        return this.body(null);
    }

    @Override
    public void close() {
        this.body().subscribe(Functions.emptyConsumer(), Functions.emptyConsumer()).dispose();
    }
}

