/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import java.net.Inet4Address;
import java.net.UnknownHostException;

public final class IPRange {
    public static final IPRange DEFAULT = new IPRange();
    public Inet4Address ipMin;
    public Inet4Address ipMax;

    public String toString() {
        if (this.ipMin == null) {
            return "";
        }
        this.ipMax = this.ipMax == null ? this.ipMin : this.ipMax;
        StringBuilder str = new StringBuilder(this.ipMin.getHostAddress());
        if (!this.ipMin.equals(this.ipMax)) {
            str.append('-');
            str.append(this.ipMax.getHostAddress());
        }
        return str.toString();
    }

    public static IPRange parse(String rangeStr) {
        try {
            String[] addrs = rangeStr.split("-");
            IPRange range = new IPRange();
            range.ipMin = (Inet4Address)Inet4Address.getByName(addrs[0]);
            if (addrs.length > 1) {
                range.ipMax = (Inet4Address)Inet4Address.getByName(addrs[1]);
            }
            return range;
        }
        catch (UnknownHostException unknownHostException) {
            throw new Error("Invalid host. Host names may not be used with IPRange.");
        }
    }
}

