/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.BlobAccessConditions;
import com.microsoft.azure.storage.blob.BlobHTTPHeaders;
import com.microsoft.azure.storage.blob.BlobRange;
import com.microsoft.azure.storage.blob.BlobURL;
import com.microsoft.azure.storage.blob.BlobURLParts;
import com.microsoft.azure.storage.blob.Metadata;
import com.microsoft.azure.storage.blob.URLParser;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.azure.storage.blob.models.PageBlobsClearPagesResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsCopyIncrementalResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsCreateResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsGetPageRangesDiffResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsGetPageRangesResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsResizeResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsUpdateSequenceNumberResponse;
import com.microsoft.azure.storage.blob.models.PageBlobsUploadPagesResponse;
import com.microsoft.azure.storage.blob.models.PageRange;
import com.microsoft.azure.storage.blob.models.SequenceNumberActionType;
import com.microsoft.rest.v2.http.HttpPipeline;
import com.microsoft.rest.v2.http.UrlBuilder;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;

public final class PageBlobURL
extends BlobURL {
    public static final int PAGE_BYTES = 512;
    public static final int MAX_PUT_PAGES_BYTES = 0x400000;

    public PageBlobURL(URL url, HttpPipeline pipeline) {
        super(url, pipeline);
    }

    @Override
    public PageBlobURL withPipeline(HttpPipeline pipeline) {
        try {
            return new PageBlobURL(new URL(this.storageClient.url()), pipeline);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public PageBlobURL withSnapshot(String snapshot) throws MalformedURLException, UnknownHostException {
        BlobURLParts blobURLParts = URLParser.parse(new URL(this.storageClient.url()));
        blobURLParts.snapshot = snapshot;
        return new PageBlobURL(blobURLParts.toURL(), this.storageClient.httpPipeline());
    }

    public Single<PageBlobsCreateResponse> create(long size, Long sequenceNumber, BlobHTTPHeaders headers, Metadata metadata, BlobAccessConditions accessConditions) {
        if (size % 512L != 0L) {
            throw new IllegalArgumentException("size must be a multiple of PageBlobURL.PAGE_BYTES.");
        }
        if (sequenceNumber != null && sequenceNumber < 0L) {
            throw new IllegalArgumentException("SequenceNumber must be greater than or equal to 0.");
        }
        headers = headers == null ? BlobHTTPHeaders.NONE : headers;
        metadata = metadata == null ? Metadata.NONE : metadata;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().createWithRestResponseAsync(0L, null, headers.getContentType(), headers.getContentEncoding(), headers.getContentLanguage(), headers.getContentMD5(), headers.getCacheControl(), metadata, accessConditions.getLeaseAccessConditions().getLeaseId(), headers.getContentDisposition(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), size, sequenceNumber, null));
    }

    public Single<PageBlobsUploadPagesResponse> uploadPages(PageRange pageRange, Flowable<ByteBuffer> body, BlobAccessConditions accessConditions) {
        BlobAccessConditions blobAccessConditions = accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        if (pageRange == null) {
            throw new IllegalArgumentException("pageRange cannot be null.");
        }
        String pageRangeStr = PageBlobURL.pageRangeToString(pageRange);
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().uploadPagesWithRestResponseAsync(body, pageRange.end() - pageRange.start() + 1L, null, pageRangeStr, accessConditions.getLeaseAccessConditions().getLeaseId(), accessConditions.getPageBlobAccessConditions().getIfSequenceNumberLessThanOrEqual(), accessConditions.getPageBlobAccessConditions().getIfSequenceNumberLessThan(), accessConditions.getPageBlobAccessConditions().getIfSequenceNumberEqual(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null));
    }

    public Single<PageBlobsClearPagesResponse> clearPages(PageRange pageRange, BlobAccessConditions accessConditions) {
        BlobAccessConditions blobAccessConditions = accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        if (pageRange == null) {
            throw new IllegalArgumentException("pageRange cannot be null.");
        }
        String pageRangeStr = PageBlobURL.pageRangeToString(pageRange);
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().clearPagesWithRestResponseAsync(0L, null, pageRangeStr, accessConditions.getLeaseAccessConditions().getLeaseId(), accessConditions.getPageBlobAccessConditions().getIfSequenceNumberLessThanOrEqual(), accessConditions.getPageBlobAccessConditions().getIfSequenceNumberLessThan(), accessConditions.getPageBlobAccessConditions().getIfSequenceNumberEqual(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null));
    }

    public Single<PageBlobsGetPageRangesResponse> getPageRanges(BlobRange blobRange, BlobAccessConditions accessConditions) {
        blobRange = blobRange == null ? BlobRange.DEFAULT : blobRange;
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().getPageRangesWithRestResponseAsync(null, null, blobRange.toString(), accessConditions.getLeaseAccessConditions().getLeaseId(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null));
    }

    public Single<PageBlobsGetPageRangesDiffResponse> getPageRangesDiff(BlobRange blobRange, String prevSnapshot, BlobAccessConditions accessConditions) {
        blobRange = blobRange == null ? BlobRange.DEFAULT : blobRange;
        BlobAccessConditions blobAccessConditions = accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        if (prevSnapshot == null) {
            throw new IllegalArgumentException("prevSnapshot cannot be null");
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().getPageRangesDiffWithRestResponseAsync(null, null, prevSnapshot, blobRange.toString(), accessConditions.getLeaseAccessConditions().getLeaseId(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null));
    }

    public Single<PageBlobsResizeResponse> resize(long size, BlobAccessConditions accessConditions) {
        if (size % 512L != 0L) {
            throw new IllegalArgumentException("size must be a multiple of PageBlobURL.PAGE_BYTES.");
        }
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().resizeWithRestResponseAsync(size, null, accessConditions.getLeaseAccessConditions().getLeaseId(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null));
    }

    public Single<PageBlobsUpdateSequenceNumberResponse> updateSequenceNumber(SequenceNumberActionType action, Long sequenceNumber, BlobAccessConditions accessConditions) {
        if (sequenceNumber != null && sequenceNumber < 0L) {
            throw new IllegalArgumentException("SequenceNumber must be greater than or equal to 0.");
        }
        BlobAccessConditions blobAccessConditions = accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        if (action == SequenceNumberActionType.INCREMENT) {
            sequenceNumber = null;
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().updateSequenceNumberWithRestResponseAsync(action, null, accessConditions.getLeaseAccessConditions().getLeaseId(), accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), sequenceNumber, null));
    }

    public Single<PageBlobsCopyIncrementalResponse> copyIncremental(URL source, String snapshot, BlobAccessConditions accessConditions) {
        accessConditions = accessConditions == null ? BlobAccessConditions.NONE : accessConditions;
        UrlBuilder builder = UrlBuilder.parse((URL)source);
        builder.setQueryParameter("snapshot", snapshot);
        try {
            source = builder.toURL();
        }
        catch (MalformedURLException e) {
            throw new Error(e);
        }
        return Utility.addErrorWrappingToSingle(this.storageClient.generatedPageBlobs().copyIncrementalWithRestResponseAsync(source, null, null, accessConditions.getHttpAccessConditions().getIfModifiedSince(), accessConditions.getHttpAccessConditions().getIfUnmodifiedSince(), accessConditions.getHttpAccessConditions().getIfMatch().toString(), accessConditions.getHttpAccessConditions().getIfNoneMatch().toString(), null));
    }

    private static String pageRangeToString(PageRange pageRange) {
        if (pageRange.start() < 0L || pageRange.end() <= 0L) {
            throw new IllegalArgumentException("PageRange's start and end values must be greater than or equal to 0 if specified.");
        }
        if (pageRange.start() % 512L != 0L) {
            throw new IllegalArgumentException("PageRange's start value must be a multiple of 512.");
        }
        if (pageRange.end() % 512L != 511L) {
            throw new IllegalArgumentException("PageRange's end value must be 1 less than a multiple of 512.");
        }
        if (pageRange.end() <= pageRange.start()) {
            throw new IllegalArgumentException("PageRange's End value must be after the start.");
        }
        return "bytes=" + pageRange.start() + '-' + pageRange.end();
    }
}

