/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.LoggingOptions;
import com.microsoft.azure.storage.blob.RequestRetryOptions;
import com.microsoft.azure.storage.blob.TelemetryOptions;
import com.microsoft.rest.v2.http.HttpClient;
import com.microsoft.rest.v2.http.HttpPipelineLogLevel;
import com.microsoft.rest.v2.http.HttpPipelineLogger;
import java.util.Locale;
import java.util.logging.Logger;

public final class PipelineOptions {
    public HttpClient client;
    public HttpPipelineLogger logger;
    public RequestRetryOptions requestRetryOptions = RequestRetryOptions.DEFAULT;
    public LoggingOptions loggingOptions = LoggingOptions.DEFAULT;
    public TelemetryOptions telemetryOptions = TelemetryOptions.DEFAULT;

    public PipelineOptions() {
        this.logger = new HttpPipelineLogger(){

            public HttpPipelineLogLevel minimumLogLevel() {
                return HttpPipelineLogLevel.OFF;
            }

            public void log(HttpPipelineLogLevel logLevel, String s, Object ... objects) {
                if (logLevel == HttpPipelineLogLevel.INFO) {
                    Logger.getGlobal().info(String.format(Locale.ROOT, s, objects));
                } else if (logLevel == HttpPipelineLogLevel.WARNING) {
                    Logger.getGlobal().warning(String.format(Locale.ROOT, s, objects));
                } else if (logLevel == HttpPipelineLogLevel.ERROR) {
                    Logger.getGlobal().severe(String.format(Locale.ROOT, s, objects));
                }
            }
        };
    }
}

