/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.RetryPolicyType;
import com.microsoft.azure.storage.blob.Utility;
import java.util.concurrent.TimeUnit;

public final class RequestRetryOptions {
    public static final RequestRetryOptions DEFAULT = new RequestRetryOptions(RetryPolicyType.EXPONENTIAL, null, null, null, null, null);
    private RetryPolicyType retryPolicyType = RetryPolicyType.EXPONENTIAL;
    private final int maxTries;
    private final int tryTimeout;
    private final long retryDelayInMs;
    private final long maxRetryDelayInMs;
    private String secondaryHost;

    public RequestRetryOptions(RetryPolicyType retryPolicyType, Integer maxTries, Integer tryTimeout, Long retryDelayInMs, Long maxRetryDelayInMs, String secondaryHost) {
        RetryPolicyType retryPolicyType2 = this.retryPolicyType = retryPolicyType == null ? RetryPolicyType.EXPONENTIAL : retryPolicyType;
        if (maxTries != null) {
            Utility.assertInBounds("maxRetries", maxTries.intValue(), 1L, Integer.MAX_VALUE);
            this.maxTries = maxTries;
        } else {
            this.maxTries = 4;
        }
        if (tryTimeout != null) {
            Utility.assertInBounds("tryTimeoutInMs", tryTimeout.intValue(), 1L, Long.MAX_VALUE);
            this.tryTimeout = tryTimeout;
        } else {
            this.tryTimeout = 60;
        }
        if (retryDelayInMs == null && maxRetryDelayInMs != null || retryDelayInMs != null && maxRetryDelayInMs == null) {
            throw new IllegalArgumentException("Both retryDelay and maxRetryDelay must be null or neither can be null");
        }
        if (retryDelayInMs != null && maxRetryDelayInMs != null) {
            Utility.assertInBounds("maxRetryDelayInMs", maxRetryDelayInMs, 1L, Long.MAX_VALUE);
            Utility.assertInBounds("retryDelayInMs", retryDelayInMs, 1L, maxRetryDelayInMs);
            this.maxRetryDelayInMs = maxRetryDelayInMs;
            this.retryDelayInMs = retryDelayInMs;
        } else {
            switch (this.retryPolicyType) {
                case EXPONENTIAL: {
                    this.retryDelayInMs = TimeUnit.SECONDS.toMillis(4L);
                    break;
                }
                case FIXED: {
                    this.retryDelayInMs = TimeUnit.SECONDS.toMillis(30L);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognize retry policy type.");
                }
            }
            this.maxRetryDelayInMs = TimeUnit.SECONDS.toMillis(120L);
        }
        this.secondaryHost = secondaryHost;
    }

    int getMaxTries() {
        return this.maxTries;
    }

    int getTryTimeout() {
        return this.tryTimeout;
    }

    String getSecondaryHost() {
        return this.secondaryHost;
    }

    long getRetryDelayInMs() {
        return this.retryDelayInMs;
    }

    long getMaxRetryDelayInMs() {
        return this.maxRetryDelayInMs;
    }

    long calculateDelayInMs(int tryCount) {
        long delay = 0L;
        switch (this.retryPolicyType) {
            case EXPONENTIAL: {
                delay = (this.pow(2L, tryCount - 1) - 1L) * this.retryDelayInMs;
                break;
            }
            case FIXED: {
                delay = this.retryDelayInMs;
            }
        }
        return Math.min(delay, this.maxRetryDelayInMs);
    }

    private long pow(long number, int exponent) {
        long result = 1L;
        int i = 0;
        while (i < exponent) {
            result *= number;
            ++i;
        }
        return result;
    }
}

