/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.ETag;
import com.microsoft.azure.storage.blob.RetryReaderOptions;
import com.microsoft.azure.storage.blob.Utility;
import com.microsoft.rest.v2.RestResponse;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.reactivestreams.Subscriber;

public final class RetryReader
extends Flowable<ByteBuffer> {
    private Single<? extends RestResponse<?, Flowable<ByteBuffer>>> response;
    private HTTPGetterInfo info;
    private RetryReaderOptions options;
    private final Function<HTTPGetterInfo, Single<? extends RestResponse<?, Flowable<ByteBuffer>>>> getter;

    public RetryReader(Single<? extends RestResponse<?, Flowable<ByteBuffer>>> initialResponse, HTTPGetterInfo info, RetryReaderOptions options, Function<HTTPGetterInfo, Single<? extends RestResponse<?, Flowable<ByteBuffer>>>> getter) {
        Utility.assertNotNull("getter", getter);
        HTTPGetterInfo hTTPGetterInfo = info = info == null ? new HTTPGetterInfo() : info;
        if (info.count != null) {
            Utility.assertInBounds("info.count", info.count, 0L, Integer.MAX_VALUE);
        }
        options = options == null ? new RetryReaderOptions() : options;
        Utility.assertInBounds("options.maxRetryRequests", options.maxRetryRequests, 0L, Integer.MAX_VALUE);
        this.response = initialResponse;
        this.info = info;
        this.options = options;
        this.getter = getter;
    }

    protected void subscribeActual(Subscriber<? super ByteBuffer> s) {
        if (this.response == null) {
            try {
                this.response = this.getter.apply(this.info);
            }
            catch (Throwable throwable) {
                s.onError(throwable);
                return;
            }
        }
        Flowable<ByteBuffer> stream = this.readActual(s, this.response, 0);
        stream.subscribe();
    }

    private Flowable<ByteBuffer> readActual(Subscriber<? super ByteBuffer> s, Single<? extends RestResponse<?, Flowable<ByteBuffer>>> response, int retryCount) {
        return response.flatMapPublisher(RestResponse::body).doOnNext(buffer -> {
            this.info.offset += (long)buffer.remaining();
            if (this.info.count != null) {
                this.info.count = this.info.count - (long)buffer.remaining();
            }
            s.onNext(buffer);
        }).doOnComplete(() -> s.onComplete()).onErrorResumeNext(throwable -> {
            if (retryCount > this.options.maxRetryRequests) {
                s.onError(throwable);
                return Flowable.empty();
            }
            if (throwable instanceof IOException) {
                Single<? extends RestResponse<?, Flowable<ByteBuffer>>> newResponse;
                try {
                    newResponse = this.getter.apply(this.info);
                }
                catch (Throwable t) {
                    s.onError(t);
                    return Flowable.empty();
                }
                return this.readActual(s, newResponse, retryCount + 1);
            }
            s.onError(throwable);
            return Flowable.empty();
        });
    }

    public static class HTTPGetterInfo {
        public long offset = 0L;
        public Long count = null;
        public ETag eTag = null;
    }
}

