/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.blob;

import com.microsoft.azure.storage.blob.IPRange;
import com.microsoft.azure.storage.blob.SASProtocol;
import com.microsoft.azure.storage.blob.Utility;
import java.net.UnknownHostException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class SASQueryParameters {
    private final String version;
    private final String services;
    private final String resourceTypes;
    private final SASProtocol protocol;
    private final OffsetDateTime startTime;
    private final OffsetDateTime expiryTime;
    private final IPRange ipRange;
    private final String identifier;
    private final String resource;
    private final String permissions;
    private final String signature;

    public String getVersion() {
        return this.version;
    }

    public String getServices() {
        return this.services;
    }

    public String getResourceTypes() {
        return this.resourceTypes;
    }

    public SASProtocol getProtocol() {
        return this.protocol;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public IPRange getIpRange() {
        return this.ipRange;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getResource() {
        return this.resource;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public String getSignature() {
        return this.signature;
    }

    SASQueryParameters(Map<String, String[]> queryParamsMap, boolean removeSASParametersFromMap) throws UnknownHostException {
        String[] queryValue = queryParamsMap.get("sv");
        if (queryValue != null) {
            this.version = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("sv");
            }
        } else {
            this.version = null;
        }
        if ((queryValue = queryParamsMap.get("ss")) != null) {
            this.services = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("ss");
            }
        } else {
            this.services = null;
        }
        if ((queryValue = queryParamsMap.get("srt")) != null) {
            this.resourceTypes = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("srt");
            }
        } else {
            this.resourceTypes = null;
        }
        if ((queryValue = queryParamsMap.get("spr")) != null) {
            this.protocol = SASProtocol.parse(queryValue[0]);
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("spr");
            }
        } else {
            this.protocol = null;
        }
        if ((queryValue = queryParamsMap.get("st")) != null) {
            this.startTime = Utility.parseDate(queryValue[0]);
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("st");
            }
        } else {
            this.startTime = null;
        }
        if ((queryValue = queryParamsMap.get("se")) != null) {
            this.expiryTime = Utility.parseDate(queryValue[0]);
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("se");
            }
        } else {
            this.expiryTime = null;
        }
        if ((queryValue = queryParamsMap.get("sip")) != null) {
            this.ipRange = IPRange.parse(queryValue[0]);
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("sip");
            }
        } else {
            this.ipRange = null;
        }
        if ((queryValue = queryParamsMap.get("si")) != null) {
            this.identifier = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("si");
            }
        } else {
            this.identifier = null;
        }
        if ((queryValue = queryParamsMap.get("sr")) != null) {
            this.resource = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("sr");
            }
        } else {
            this.resource = null;
        }
        if ((queryValue = queryParamsMap.get("sp")) != null) {
            this.permissions = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("sp");
            }
        } else {
            this.permissions = null;
        }
        if ((queryValue = queryParamsMap.get("sig")) != null) {
            this.signature = queryValue[0];
            if (removeSASParametersFromMap) {
                queryParamsMap.remove("sig");
            }
        } else {
            this.signature = null;
        }
    }

    SASQueryParameters(String version, String services, String resourceTypes, SASProtocol protocol, OffsetDateTime startTime, OffsetDateTime expiryTime, IPRange ipRange, String identifier, String resource, String permissions, String signature) {
        this.version = version;
        this.services = services;
        this.resourceTypes = resourceTypes;
        this.protocol = protocol;
        this.startTime = startTime;
        this.expiryTime = expiryTime;
        this.ipRange = ipRange;
        this.identifier = identifier;
        this.resource = resource;
        this.permissions = permissions;
        this.signature = signature;
    }

    private void tryAppendQueryParameter(StringBuilder sb, String param, Object value) {
        if (value != null) {
            if (sb.length() == 0) {
                sb.append('?');
            } else {
                sb.append('&');
            }
            sb.append(Utility.safeURLEncode(param)).append('=').append(Utility.safeURLEncode(value.toString()));
        }
    }

    public String encode() {
        String[] params = new String[]{"sv", "ss", "srt", "spr", "st", "se", "sip", "si", "sr", "sp", "sig"};
        StringBuilder sb = new StringBuilder();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param;
            switch (param = stringArray[n2]) {
                case "sv": {
                    this.tryAppendQueryParameter(sb, param, this.version);
                    break;
                }
                case "ss": {
                    this.tryAppendQueryParameter(sb, param, this.services);
                    break;
                }
                case "srt": {
                    this.tryAppendQueryParameter(sb, param, this.resourceTypes);
                    break;
                }
                case "spr": {
                    this.tryAppendQueryParameter(sb, param, (Object)this.protocol);
                    break;
                }
                case "st": {
                    this.tryAppendQueryParameter(sb, param, this.startTime == null ? null : Utility.ISO8601UTCDateFormatter.format(this.startTime));
                    break;
                }
                case "se": {
                    this.tryAppendQueryParameter(sb, param, this.expiryTime == null ? null : Utility.ISO8601UTCDateFormatter.format(this.expiryTime));
                    break;
                }
                case "sip": {
                    this.tryAppendQueryParameter(sb, param, this.ipRange);
                    break;
                }
                case "si": {
                    this.tryAppendQueryParameter(sb, param, this.identifier);
                    break;
                }
                case "sr": {
                    this.tryAppendQueryParameter(sb, param, this.resource);
                    break;
                }
                case "sp": {
                    this.tryAppendQueryParameter(sb, param, this.permissions);
                    break;
                }
                case "sig": {
                    this.tryAppendQueryParameter(sb, param, this.signature);
                }
            }
            ++n2;
        }
        return sb.toString();
    }
}

